#modname "Cherry Recruitable Rebalance"
#description "Rebalances most recruitable units in the game, by adjusting stats, costs, and equipment, so that there are fewer useless units and more useful ones."
#icon "./cherrydata/cherrymod.tga"
#version 7.1
#domversion 2.15

-- Version 7.1 fixes problems with S&A mages noted by Arralen.


-- General Modding


-- This gives provinces 50% more supplies than usual.  Thus, to some extent:
-- It helps AIs avoid starvation, and allows mundane troops to better compete with summoned (need not eat) units.
-- Also, it makes militia, light infantry, light cavs, and slingers more viable...
-- and allows you to use mundane troops without requiring nature magic on your pretender (for supply items)

#supplymult 150


-- New equipment

-- armor

#newarmor 300
#name "Eyepatch"
#type 6
#prot 1
#def -2
#enc 0
#end

#newarmor 301
#name "Pocket Protector"
#type 5
#prot 1
#def 0
#enc 0
#end

-- rcost 6
#newarmor 302
#name "Ringmail Hauberk of Ulm"
#type 5
#prot 8
#def -1
#enc 1
#end

-- rcost 16
#newarmor 303
#name "Plate Cuirass of Ulm"
#type 5
#prot 12
#def -1
#enc 2
#end

-- rcost 16
#newarmor 304
#name "Full Chain Mail of Ulm"
#type 5
#prot 15
#def -3
#enc 3
#end

-- for assassins
-- their default protection is too low
-- rcost 1
#newarmor 305
#name "Armguards"
#type 4
#prot 2
#def 0
#enc 0
#end

-- rcost 4
#newarmor 306
#name "Sharkskin Cuirass"
#type 5
#prot 4
#def 0
#enc 0
#end

-- rcost 6
#newarmor 307
#name "Sharkskin Hauberk"
#type 5
#prot 5
#def -1
#enc 0
#end

-- rcost 8
#newarmor 308
#name "Full Sharkskin Armor"
#type 5
#prot 7
#def -2
#enc 1
#end

-- rcost 13
-- 1 extra protection, 1 less encumbrance because
-- it is custom made and fitted by the kingdom's best armorer
#newarmor 309
#name "Imperial Scale Mail"
#type 5
#prot 12
#def -2
#enc 2
#end

-- rcost 3
#newarmor 310
#name "Sacred Shield"
#type 4
#prot 4
#def 2
#enc 1
#magic
#end

-- rcost 0
#newarmor 311
#name "Armor Scraps"
#type 5
#prot 2
#enc 1
#end

-- rcost ?
#newarmor 312
#name "Light Centaur Barding"
#type 5
#prot 6
#enc 0
#def 0
#end

-- rcost ?
-- To make soulless slightly resistant to missiles
-- since they have no vital organs...
#newarmor 313
#name "Missile Resistance"
#type 4
#prot 0
#def 1
#enc 0
#end

-- rcost 12
-- for Tuatha / Sidhe
#newarmor 314
#name "Bronze Chain Cuirass"
#type 5
#prot 8
#def -1
#enc 1
#end

-- rcost 1
-- for Tuatha / Sidhe
#newarmor 315
#name "Bronze Helmet"
#type 6
#prot 1
#end

-- rcost ?
-- for Arco
#newarmor 316
#name "Bronze Full Helmet"
#type 6
#prot 2
#def -1
#enc 1
#end

-- rcost ?
-- for Arco
#newarmor 317
#name "Bronze Ringmail Cuirass"
#type 5
#prot 5
#def 0
#enc 1
#end

-- rcost ?
#newarmor 318
#name "Bronze Centaur Barding"
#type 5
#prot 12
#def -2
#enc 3
#end

-- rcost ?
#newarmor 319
#name "Mammoth Leather Armor"
#type 5
#prot 8
#def -1
#enc 1
#end

-- For REALLY REALLY good swordsmen.
-- Lets them block projectiles with their sword.
#newarmor 320
#name "Sword Deflection"
#type 4
#prot 0
#def 4
#enc 0
#end

-- For TC heroes
#newarmor 321
#name "Immortal's Robe"
#type 5
#prot 2
#def 0
#enc 0
#end

-- For TC hero
#newarmor 322
#name "Flea-Infested Cape"
#type 5
#prot 1
#def 0
#enc 0
#end

-- For units with silver chain mail, like Knights of Avalon
#newarmor 323
#name "Silver Chain Mail"
#type 5
#prot 14
#def -3
#enc 2
#end

-- For units with silver helmets, like Knights of Avalon
#newarmor 324
#name "Silver Helmet"
#type 6
#prot 2
#def -1
#enc 0
#end

-- For Man's Green Knight
#newarmor 325
#name "Shimmering Green Mail"
#type 5
#prot 15
#def -3
#enc 2
#end

-- For units with gilded chain mail, like Marignon
#newarmor 326
#name "Gilded Chain Hauberk"
#type 5
#prot 11
#def -2
#enc 2
#end

-- For units with gilded chain mail, like Marignon
#newarmor 327
#name "Gilded Chain Mail"
#type 5
#prot 14
#def -3
#enc 3
#end

-- For units with gilded chain mail, like Marignon
#newarmor 328
#name "Gilded Full Helmet"
#type 6
#prot 2
#def -1
#enc 0
#end

-- A not-as-good version of the magical Black Steel Helmet
#newarmor 329
#name "Full Helmet of Ulm"
#type 6
#prot 2
#def 0
#enc 0
#end




-- weapons

#newweapon 900
#name "Hook"
#bonus
#def 2
#att -2
#dmg 1
#len 0
#sound 7
#end

#newweapon 901
#name "Compass"
#def 0
#att -2
#dmg -3
#len 0
#sound 7
#end

#newweapon 902
#name "Ruler"
#def 0
#att 0
#dmg 1
#len 0
#sound 7
#end

-- rcost 1
#newweapon 903
#name "Throwing Knife"
#dmg 1
#att 0
#range 8
#ammo 2
#flyspr 403 1
#sound 46
#end

-- similar to bite, but much more vicious,
-- using claws and teeth together
#newweapon 904
#name "Shred"
#dmg 3
#att 1
#def 0
#len 0
#nratt 2
#twohanded
#sound 38
#end

-- similar to bite, but for (e.g.) jaguars, who have amazingly powerful jaws
-- that are designed for crushing turtle shells.
#newweapon 905
#name "Crushing Bite"
#armorpiercing
#dmg 1
#att 1
#def 0
#len 0
#sound 38
#end

#newweapon 906
#name "Niefel Axe"
#dmg 10
#att 0
#def 0
#len 4
#sound 10
#end

#newweapon 907
#name "Niefel Longsword"
#dmg 10
#att 2
#def 0
#len 4
#aoe 1
#sound 8
#end

-- rcost 3
#newweapon 908
#name "Holy Spear"
#dmg 4
#att 0
#def 0
#len 4
#magic
#sound 12
#end

-- rcost 4
-- I want to add "Soul Slay" to this, but...
-- it's not available for modding yet
#newweapon 909
#name "Soul Spear"
#dmg 5
#att 2
#def 0
#len 4
#magic
#sound 12
#end

-- rcost ?
-- Dao: an ancient Chinese sword, curved with 1 edge.
#newweapon 910
#name "Imperial Dao"
#dmg 7
#att 1
#def 0
#len 2
#sound 8
#end

-- rcost ?
-- Sword that Paladins get. 
-- When it becomes possible, this will get a bonus versus undead.
#newweapon 911
#name "Holy Sword"
#dmg 7
#att 1
#def 1
#len 2
#sound 8
#magic
#end

-- rcost 3?
-- For Sidhe Champions, made of bronze
#newweapon 912
#name "Ancient Bronze Sword"
#dmg 4
#att 0
#def 1
#len 1
#nratt 2
#sound 8
#end

-- rcost 6
-- For Ulm Guardians
#newweapon 913
#name "Black Steel Halberd"
#dmg 11
#att 0
#def 0
#len 4
#sound 10
#magic
#end

#newweapon 914
#name "Shadow Spear"
#dmg 3
#att 0
#def 0
#len 4
#sound 12
#secondaryeffect 306
#end

-- rcost ?
-- For Arco, made of bronze
#newweapon 915
#name "Bronze Short Sword"
#dmg 4
#att 0
#def 1
#len 1
#sound 8
#end

#newweapon 916
#name "Obsidian Dagger"
#dmg 1
#att 1
#def 0
#len 0
#sound 7
#end

#newweapon 917
#name "Pruning Knife"
#dmg 1
#att 0
#def 0
#len 0
#armorpiercing
#magic
#sound 7
#end

#newweapon 918
#name "Slap"
#dmg -4
#att 1
#def -1
#len 0
#nratt 2
#sound 7
#end

#newweapon 919
#name "Punch"
#dmg 0
#att 0
#def 0
#len 0
#sound 7
#end

#newweapon 920
#name "Kick"
#dmg 1
#att 0
#def 0
#len 1
#bonus
#sound 7
#end









-- modified equipment


-- Armors:

#selectarmor 17
#name "Full Scale Mail"
#def -2
#end

-- Corrects capitalization, as noted by Edi
#selectarmor 31
#name "Rusty Scale Mail Hauberk"
#prot 7
#def -1
#enc 2
#end

-- Corrects capitalization, as noted by Edi
#selectarmor 32
#name "Rusty Ring Mail Hauberk"
#prot 5
#def -1
#enc 1
#end

-- Corrects capitalization, as noted by Edi
#selectarmor 33
#name "Rusty Chain Mail Hauberk"
#prot 9
#def -2
#enc 2
#end

-- Improves Spider Armor / Spider Warriors
-- We'll assume they use spider silk...
#selectarmor 111
#name "Spider Armor"
#prot 16
#def -4
#enc 4
#end





-- Weapons:

-- maul becomes armor piercing because:
-- a) it is (default) an utterly terrible weapon and
-- b) the crushing/concussion damage should go through soft and hard armors,
-- to break bones without needing to penetrate the armor
-- rcost 4
#selectweapon "Maul"
#dmg 5
#armorpiercing
#end

#selectweapon 22
#name "Sling"
#att -1
#end

#selectweapon 24
#name "Long Bow"
#dmg 9
#armorpiercing
#end

#selectweapon 23
#name "Short Bow"
#range 32
#end

#selectweapon 25
#name "Crossbow"
#range 32
#end

#selectweapon 260
#name "Throwing Axe"
#att -2
#end

-- pincers are much more thickly armored than the rest of a creature,
-- and are fairly long, so I would consider them relatively invulnerable
-- and similar to a sword in engagement distance / repel ability.
#selectweapon 235
#name "Pincer"
#len 2
#att 1
#end

#selectweapon 273
#name "Pincer"
#len 2
#att 1
#end

-- claw for units mounted on lobsters
#selectweapon 47
#name "Claw"
#len 2
#end

-- Salamander attack. Range is now equal to a longspear, so militias cannot
-- attack with impunity
#selectweapon 48
#name "Fire Flare"
#len 5
#att 6
#end

-- Alicorns are armor piercing.
-- For reference, read "The Last Unicorn" in which the unicorn has
-- slain dragons with her horn.  This is impossible without pierce.
#selectweapon 330
#name "Alicorn"
#dmg 12
#armorpiercing
#end

-- Hoof for mounted units.
-- This prevents horses from kicking a spiny enemy
-- and poisoning the rider.
#selectweapon 56
#name "Hoof"
#len 1
#end

-- Claw for Gryphon Rider.
-- This prevents Gryphons from hitting a spiny enemy
-- and poisoning the rider.
#selectweapon 236
#name "Claw"
#len 1
#end

-- Bite for Gryphon Rider.
-- This prevents Gryphon from hitting a spiny enemy
-- and poisoning the rider.
#selectweapon 237
#name "Bite"
#len 1
#end

-- Bite for Serpent Rider.
-- This prevents serpents from hitting a spiny enemy
-- and poisoning the rider.
#selectweapon 19
#name "Bite"
#len 1
#end

-- Lu Tung-Pin's weapon
#selectweapon 344
#name "Demon-Slayer"
#nratt 2
#def 1
#secondaryeffect 171
#end

-- Lu Tung-Pin's weapon
#selectweapon 345
#name "Fly Whisk"
#nratt 2
#end

#selectweapon 308
#name "Glaive"
#dmg 10
#att 0
#def -1
#len 4
#end

#selectweapon 5
#name "Halberd"
#dmg 10
#att 0
#def -1
#len 4
#end

#selectweapon 17
#name "Axe"
#dmg 7
#att -1
#def 0
#len 1
#end





























-- Archers.  guideline: 7g

#selectmonster 17
#name "Light Archer"
#descr "Soldiers armed with bows, they are vulnerable in melee combat. Light Archers wear minimal armor and receive little training, allowing them to be rapidly recruited and deployed to the front lines."
#gcost 7
#mapmove 2
#ap 12
#end

#selectmonster 32
#name "Heavy Archer"
#descr "Soldiers armed with bows, they are vulnerable in melee combat. Heavy Archers undergo rigorous military training, wear helmets and plate cuirasses, and are no less competent at close combat than regular troops."
#gcost 10
#att 10
#def 10
#mor 10
#prec 10
#end

#selectmonster 33
#name "Archer"
#gcost 8
#mor 9
#att 9
#def 9
#mapmove 2
#end

#selectmonster 47
#name "Light Crossbowman"
#gcost 7
#descr "Crossbows fire bolts capable of penetrating thick armor long range. Though capable of killing heavy troops with a single shot, the slow reloading mechanism reduces the fire rate to half that of a normal bow. Light Crossbowmen receive little training and only carry a dagger as a last resort."
#mapmove 2
#end

#selectmonster 48
#name "Crossbowman"
#gcost 8
#mor 9
#att 9
#def 9
#end

#selectmonster 49
#name "Heavy Crossbowman"
#descr "Crossbows fire bolts capable of penetrating thick armor long range. Though capable of killing heavy troops with a single shot, the slow reloading mechanism reduces the fire rate to half that of a normal bow. Heavy Crossbowmen undergo rigorous military training, wear helmets and plate cuirasses, and are no less competent at close combat than regular troops."
#att 10
#def 10
#mor 10
#gcost 10
#end

#selectmonster 50
#name "Slinger"
#gcost 4
#hp 9
#str 9
#prec 9
#ap 11
#end

#selectmonster 55
#name "Longbowman"
#gcost 12
#prec 11
#end

#selectmonster 56
#name "Forester"
#hp 11
#mor 11
#att 11
#def 11
#supplybonus 2
#end

#selectmonster 59
#name "Elite Longbowman"
#descr "Only tall and exceptionally strong archers are armed with longbows capable of penetrating even thick armor. The longbow has a very long range, though it is not quite as powerful as a crossbow."
#gcost 12
#rcost 6
#hp 11
#mor 10
#mr 10
#str 11
#att 11
#prec 12
#enc 3
#armor "Leather Hauberk"
#weapon "Short Sword"
#weapon "Long Bow"
#end

#selectmonster 123
#name "Tribal Archer"
#gcost 7
#end

#selectmonster 125
#name "Woodsman Blowpipe"
#gcost 9
#end

#selectmonster 126
#name "Woodsman"
#gcost 9
#end

#selectmonster 127
#name "Blizzard Warrior"
#gcost 10
#end

#selectmonster 128
#name "Caelian Archer"
#gcost 9
#mor 9
#end

#selectmonster 218
#name "Royal Crossbowman"
#descr "Royal Crossbowmen undergo the same training as Marignon's melee forces, and scorn archers who flee when the front lines break.  They wear light armor and fire bolts capable of killing heavy units at long range. Despite their training, even elite crossbowmen can only fire one bolt every two rounds."
#gcost 10
#prec 11
#end

#selectmonster 273
#name "Hoburg Crossbow"
#gcost 7
#rcost 5
#end

#selectmonster 290
#name "Mercenary Crossbowman"
#descr "Mercenaries have good armaments and some experience. Crossbowman who have survived long enough to earn a living as mercenaries have better aim, endurance, and combat ability than their fallen brethren."
#prec 11
#end

-- note:  hurlers won't have boulders anymore when melee combat starts.
-- Thus, they shouldn't have lower defense than militias...
#selectmonster 300
#name "Jotun Hurler"
#gcost 30
#def 9
#end

#selectmonster 331
#name "Illithid"
#gcost 50
#rcost 3
#end

#selectmonster 348
#name "Crystal Amazon"
#descr "Amazons are a people of semi-civilized tribes ruled by women. The Amazonian culture is centered around warfare and prowess in combat. Their people are comprised of four tribes - Crystal, Garnet, Onyx, and Jade - led by Sorceresses and Priestess trained in magic. Crystal Amazons are adept archers but fare poorly in melee."
#gcost 10
#end
-- normal cost is... ?

#selectmonster 417
#name "Arbalestier"
#descr "The Arbalestiers of Ulm are of larger stock than normal humans and wear black steel plate armor. Their huge arbalests have much greater power and range than any other hand-held weapon, but can only be fired once per three turns. The bolts tear through steel like papyrus and can kill heavily armored units with a single shot. Arbalestiers are some of the few units capable of hurting Ulm's own Black Plate Infantry, and should be deployed with care."
#gcost 10
#rcost 23
#str 11
#hp 12
#prec 11
#mr 9
#enc 2
#weapon "Short Sword"
#weapon "Arbalest"
#armor "Plate Cuirass of Ulm"
#armor "Helmet"
#end

#selectmonster 482
#name "Villain"
#gcost 9
#rcost 8
#hp 10
#prot 0
#mor 9
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#ap 12
#mapmove 2
#weapon "Mace"
#weapon "Short Bow"
#armor "Full Leather Armor"
#armor "Armguards"
#pillagebonus 1
#stealthy 0
#forestsurvival
#mountainsurvival
#end

-- default gcost 25
-- being trained as assassins, they should have better fighting skills than militia!
#selectmonster 503
#name "Poison Slinger"
#gcost 25
#prec 11
#att 9
#def 9
#end

#selectmonster 749
#name "Sapper"
#gcost 20
#rcost 20
#armor "Helmet"
#armor "Ringmail Hauberk of Ulm"
#prec 11
#hp 12
#enc 4
#end

#selectmonster 797
#name "Composite Bowman"
#descr "The Archers of T'ien Ch'i use composite bows and wear leather armor.  They are better trained than most archers, and their bows do more damage at a greater distance."
#gcost 8
#att 10
#def 9
#prec 10
#end

#selectmonster 801
#name "Imperial Archer"
#gcost 11
#att 11
#end

#selectmonster 802
#name "Imperial Crossbowman"
#gcost 11
#att 11
#end

#selectmonster 879
#name "Machaka Archer"
#descr "Machakan Archers are equipped only with bows and daggers. Years of hunting on the savannah have honed their archery skills, but they receive no formal combat training, and die or flee quickly when exposed to enemy fire."
#gcost 6
#att 9
#prec 11
#end

-- Let's be honest here, rangers are better fighters than standard infantry!
#selectmonster 1017
#name "Ranger of Ulm"
#descr "Trained in forestry, scouting, and combat, the Rangers of Ulm are masters of wilderness survival. Along with a crossbow and a keen eye, their combination of skill, wit, and durable Ulmian physique allows traversal through the barren lands that even vultures fear, where ants and roaches alike succumb to the deadly claws of starvation, and plants live only long enough to exhaust their seeds before wilting upon the dessicated soil. Rangers are armed with short swords and wear light armor, and operate in small groups that move undetected through enemy lands. Like all inhabitants of Ulm, Rangers are large and powerful, but vulnerable to magic."
#gcost 13
#mor 11
#att 11
#def 11
#str 11
#enc 2
#weapon "Short Sword"
#weapon "Crossbow"
#patrolbonus 1
#neednoteat
#end

#selectmonster 1018
#name "Ranger Captain"
#descr "Trained in forestry, scouting, and combat, the Rangers of Ulm are masters of wilderness survival. Along with a crossbow and a keen eye, their combination of skill, wit, and durable Ulmian physique allows traversal through the barren lands that even vultures fear, where ants and roaches alike succumb to the deadly claws of starvation, and plants live only long enough to exhaust their seeds before wilting upon the dessicated soil. Rangers are armed with short swords and wear light armor, and operate in small groups that move undetected through enemy lands. Like all inhabitants of Ulm, Rangers are large and powerful, but vulnerable to magic."
#gcost 50
#okleader
#mor 12
#att 12
#def 11
#str 11
#enc 2
#hp 13
#weapon "Short Sword"
#weapon "Crossbow"
#stealthy 5
#patrolbonus 2
#neednoteat
#end

-- default gcost 14, prec 9
-- I want to keep prec at 9, but...
-- the axe has -4 prec and I can't change it.
#selectmonster 1090
#name "Abysian Axe Thrower"
#gcost 10
#rcost 10
#prec 9
#end


































-- Militias.  guideline: 5g

#selectmonster 18
#name "Trained Militia"
#descr "Militia are quickly assembled troops with inferior morale, cheap armaments, and low life expectancy.  Trained Militia are told which end of the spear points toward the enemy, and given a helmet to protect that knowledge."
#gcost 5
#prec 9
#end

#selectmonster 30
#name "Militia"
#descr "Militia are quickly assembled troops with inferior morale and cheap armaments.  They often volunteer in provinces far from the front lines in order to draw a free salary at no personal risk."
#gcost 3
#hp 9
#str 9
#prec 8
#end

#selectmonster 31
#name "Medium Militia"
#descr "Militia are quickly assembled troops with inferior morale, cheap armaments, and low life expectancy."
#gcost 5
#prec 8
#end

#selectmonster 168
#name "C'tis Militia"
#descr "The Militia of C'tis are the lightest and most cowardly of the swamp kingdom's troops, and are primarily used to tire the enemy or confuse his archers.  They have partial resistance to poison, and a scaly which hide renders them better protected than most human militia."
#gcost 4
#prec 8
#end

#selectmonster 217
#name "Flagellant"
#gcost 6
#end

#selectmonster 239
#name "Harpy"
#gcost 6
#def 10
#end

-- Jotun Militia gets a morale boost and price decrease because they are really bad.
#selectmonster 277
#name "Jotun Militia"
#gcost 16
#mor 11
#end

-- rcost 2, since there are not unlimited supplies of
-- insane atlantians...
-- and lower stats from physical and mental abuse leading to mental collapse.
#selectmonster 337
#name "Lobo Guard"
#gcost 3
#rcost 2
#hp 12
#att 8
#def 6
#end

#selectmonster 483
#name "Hoburg Militia"
#gcost 3
#end

#selectmonster 720
#name "Mictlan Slave"
#descr "The Kings of Mictlan have always used slaves in warfare.  Slaves are armed with spears, but are not given armor or training and tend to break in the face of disciplined soldiers.  Only the Priest Kings and Tribal Kings of Mictlan can levy Slave Warriors."
#gcost 0
#end

#selectmonster 878
#name "Machaka Militia"
#gcost 3
#str 9
#mapmove 2
#end

#selectmonster 962
#name "Madman"
#gcost 0
#att 8
#def 5
#prec 6
#end

#selectmonster 1007
#name "Mad Deep One"
#gcost 0
#end

#selectmonster 1008
#name "Fanatic Deep One"
#gcost 0
#end

#selectmonster 1009
#name "Holy Deep One"
#end

#selectmonster 1022
#name "Thrall"
#gcost 0
#end




































--Light Infantry: Trained units, up to 8 protection, guideline: 7g

#selectmonster 11
#name "Trident Gladiator"
#gcost 6
#descr "Gladiators are slaves trained to fight in arenas for the Emperor's pleasure.  Those who survive become very skilled in combat and often use exotic weapons.  In times of crisis, they can be used in warfare in exchange for their freedom.  Though extremely cheap to purchase, Gladiators will only fight a single battle before leaving.  They are skilled warriors but poor soldiers."
#weapon "Trident"
#weapon "Net"
#str 11
#ap 12
#end

#selectmonster 12
#name "Flail Gladiator"
#descr "Gladiators are slaves trained to fight in arenas for the Emperor's pleasure.  Those who survive become very skilled in combat and often use exotic weapons.  In times of crisis, they can be used in warfare in exchange for their freedom.  Though extremely cheap to purchase, Gladiators will only fight a single battle before leaving.  They are skilled warriors but poor soldiers."
#gcost 6
#ap 12
#end

-- prot 6, no javelin, just leather cuirass and shield
#selectmonster 28
#name "Light Infantry"
#gcost 7
#end

-- being deovted to war, they should have undergone strength training
#selectmonster 51
#name "Battle Vestal"
#descr "Battle Vestals are priestly maidens devoted to war. Their spear and shield are sanctified by Theurgs, granting additional protection and the ability to harm ethereal creatures. They wear no armor, relying on their quickness to avoid their enemies' weapons. The Vestals are sacred and can be blessed by priests."
#gcost 14
#rcost 6
#mr 12
#str 10
#armor "Sacred Shield"
#weapon "Holy Spear"
#end

#selectmonster 110
#name "Atlantian Spearman"
#descr "The Spearmen of Atlantis wield poisonous coral-tipped spears, and wear no armor."
#gcost 7
#end

#selectmonster 111
#name "Atlantian Infantry"
#descr "Atlantian Infantry wield poisonous coral-tipped spears, and carry turtle-shell shields for protection."
#gcost 8
#end

#selectmonster 124
#name "Tribal Warrior"
#gcost 7
#end

-- no shield
#selectmonster 129
#name "Spire Horn Warrior"
#gcost 10
#rcost 6
#end

#selectmonster 139
#name "Barbarian Swordsman"
#descr "Barbarians are wild men living in harsh conditions.  Fighting with heavy weapons and light armor, they are feared for their strength, stamina, and unbridled enthusiasm for pillaging.  Despite having great offensive capabilities, Barbarians rout easily due to a lack of discipline.  They occasionally go berserk in combat."
#gcost 12
#rcost 9
#berserk 1
#att 11
#def 11
#ap 14
#end

#selectmonster 140
#name "Barbarian"
#descr "Barbarians are wild men living in harsh conditions.  Fighting with heavy weapons and light armor, they are feared for their strength, stamina, and unbridled enthusiasm for pillaging.  Despite having great offensive capabilities, Barbarians rout easily due to a lack of discipline.  They occasionally go berserk in combat."
#gcost 12
#rcost 7
#berserk 1
#att 11
#def 11
#ap 14
#end

#selectmonster 141
#name "Barbarian Chief"
#standard 3
#berserk 3
#gcost 30
#att 12
#def 12
#mor 12
#ap 14
#end

#selectmonster 147
#name "Barbarian Lord"
#standard 5
#berserk 4
#att 13
#def 12
#mor 13
#ap 14
#end

#selectmonster 155
#name "Velite"
#gcost 8
#end

#selectmonster 167
#name "C'tis Light Infantry"
#descr "The Light Infantry of C'tis are armed with spears and javelins.  For protection, they rely upon their scaly skin and round shields.  They have partial resistance to poison."
#gcost 8
#end

#selectmonster 169
#name "Taskmaster"
#descr "The Taskmaster is in charge of the enslaved predator lizards. Taskmasters are armed with a whip, which is also used to keep the predators in line. They have partial resistance to poison, and quick reflexes; not through special training, but because those with slow reflexes soon lose their tails, limbs, or worse to particularly fiesty captives. Most Taskmasters hunt, gather, tend, and train slave lizards, and never lead an army. Though no C'tissian can match a Runner in a short sprint, the fastest Taskmasters are selected and conditioned for the endurance to lead slave lizards into battle."
#gcost 30
#rcost 1
#enc 3
#def 12
#ap 12
#mapmove 3
#end

#selectmonster 171
#name "C'tis Slave Warrior"
#descr "In C'tissian society, predator lizards are considered stupid, aggressive, and untrustworthy.  Members of the predator race are enslaved and forced to endure manual labor.  Their temperment and strength make them well-suited for combat, and some are trained in warfare by special Taskmasters.  The Slave Warriors are armed with tridents and use their powerful jaws to bite opponents in close combat.  They have partial resistance to poison."
#gcost 10
#end

#selectmonster 172
#name "C'tis Elite Warrior"
#descr "Some prominant slave warriors receive additional training and scale cuirasses for protection.  Though feared by ordinary C'tissians, they are disciplined enough not to kill and eat their masters.  They have partial resistance to poison."
#gcost 13
#att 12
#def 10
#end

#selectmonster 173
#name "Runner"
#gcost 11
#ap 18
#def 11
#end

#selectmonster 176
#name "Triton"
#gcost 7
#att 9
#def 9
#mor 9
#end

#selectmonster 174
#name "Triton"
#gcost 9
#end

#selectmonster 175
#name "Triton Guard"
#gcost 10
#end

#selectmonster 406
#name "Triton Lord"
#gcost 30
#end

#selectmonster 199
#name "Cardaces"
#gcost 7
#end

#selectmonster 201
#name "Peltast"
#gcost 7
#end

#selectmonster 205
#name "Raptor"
#gcost 8
#end

#selectmonster 206
#name "Shambler"
#gcost 21
#mor 12
#end

#selectmonster 207
#name "Shambler Chief"
#gcost 45
#mor 12
#hp 23
#str 16
#weapon 45
#weapon 29
#ambidextrous 1
#end

#selectmonster 208
#name "War Shambler"
#gcost 32
#mor 13
#att 11
#def 10
#end

#selectmonster 227
#name "Satyr"
#descr "Satyrs are wild halfmen with the hindquarters and horns of a goat. They are powerfully built and can easily outrun the swiftest of humans. The Satyrs are selfish beings who lack discipline and will quickly flee from battle if the odds are against them. Their strong connection to Nature gives Satyrs a strong resistance to magic. Untrained Satyrs carry nothing but a spear, and fare poorly in combat. All light Satyrs are stealthy and useful as scouts."
#gcost 6
#hp 11
#att 9
#def 11
#prot 2
#end

#selectmonster 228
#name "Satyr Infantry"
#descr "Satyrs are wild halfmen with the hindquarters and horns of a goat. They are powerfully built and can easily outrun the swiftest of humans. The Satyrs are selfish beings who lack discipline and will quickly flee from battle if the odds are against them. Their strong connection to Nature gives Satyrs a strong resistance to magic. Satyr Infantries recieve minimal training, and carry bucklers or javelins. All light Satyrs are stealthy and useful as scouts."
#gcost 8
#prot 2
#end

#selectmonster 229
#name "Satyr Infantry"
#descr "Satyrs are wild halfmen with the hindquarters and horns of a goat. They are powerfully built and can easily outrun the swiftest of humans. The Satyrs are selfish beings who lack discipline and will quickly flee from battle if the odds are against them. Their strong connection to Nature gives Satyrs a strong resistance to magic. These lighter Satyr infantries wield bucklers and sometimes carry javelins. All light Satyrs are stealthy and useful as scouts."
#gcost 8
#prot 2
#end

-- technically an animal, but usable as infantry by Black Forest Ulm.
-- cold resist because it is used in Jotunheim and mentions cold in description
-- to reflect their speed and attack skill, I bumped attack to 12
-- Wolves are capable predators, and can feed themselves
#selectmonster 284
#name "Wolf"
#gcost 0
#att 12
#coldres 25
#neednoteat
#end

#selectmonster 335
#name "Slave Trooper"
#gcost 7
#mor 9
#end

#selectmonster 400
#name "Skin Shifter"
#gcost 21
#hp 15
#mor 13
#att 11
#def 11
#prot 1
#mr 12
#coldres 25
#end
--Vanheim default shifter

#selectmonster 399
#name "Werewolf"
#ap 18
#def 13
#coldres 25
#end
-- Werewolves should be very very fast.

#selectmonster 401
#name "Bitch Queen"
#ap 18
#def 15
#coldres 25
#end
-- Werewolves should be very very fast.

#selectmonster 633
#name "Werewolf"
#ap 18
#def 13
#coldres 25
#end

#selectmonster 852
#name "Werewolf"
#ap 18
#def 13
#coldres 25
#end

#selectmonster 854
#name "Werewolf"
#ap 18
#def 13
#coldres 25
#end

#selectmonster 423
#name "Lizard Warrior"
#gcost 13
#end

#selectmonster 430
#name "Black Harpy"
#descr "Black Harpies are large, darkly feathered Harpies gifted with intelligence beyond the slow cunning of ordinary Harpies. They serve as flying scouts and sometimes lead small suprise attacks, but lack the charisma needed to command large armies."
#poorleader
#gcost 30
#rcost 1
#def 11
#str 9
#end

-- scouts and spies should generally be chosen for having sharp eyesight...
#selectmonster 426
#name "Scout"
#gcost 20
#prec 11
#end

-- scouts and spies should generally be chosen for having sharp eyesight...
#selectmonster 427
#name "Spy"
#gcost 30
#prec 11
#end

-- I gave them a throwing knife... a favorite assassin weapon
#selectmonster 428
#name "Assassin"
#gcost 60
#rcost 5
#weapon "Short Sword"
#weapon 126
#weapon "Throwing Knife"
#armor "Leather Cuirass"
#armor "Armguards"
#end

#selectmonster 431
#name "Arcoscephalean Scout"
#descr "Scouts are trained to pass unseen through enemy territory. Their reports on enemy army movements and on the resources in enemy lands are invaluable to the prudent warlord."
#gcost 20
#rcost 4
#prec 11
#end

#selectmonster 432
#name "Atlantian Scout"
#gcost 20
#rcost 1
#prot 2
#prec 9
#end

#selectmonster 435
#name "Maenad"
#mr 8
#gcost 0
#forestsurvival
#end

-- Best scout in the game. Atlantis is a distant second.
#selectmonster 484
#name "Caelian Scout"
#gcost 25
#rcost 19
#prec 12
#end

#selectmonster 504
#name "Falchioneer"
#gcost 11
#att 11
#def 11
#ambidextrous 3
#end

#selectmonster 538
#name "Theurg Communicant"
#gcost 50
#rcost 1
#hp 9
#str 9
#mor 14
#att 5
#def 5
#prec 4
#mr 12
#noleader
#end

-- All Jotunheim native races should have SOME cold resistance
#selectmonster 541
#name "Vaetti"
#gcost 6
#rcost 5
#coldres 25
#end

#selectmonster 574
#name "Amber Clan Triton"
#gcost 9
#rcost 14
#end
--cost unkn

#selectmonster 629
#name "Stalker"
#weapon "Short Sword"
#weapon 126
#weapon "Throwing Knife"
#armor "Leather Cuirass"
#armor "Armguards"
#end
--cost unkn

#selectmonster 662
#name "Velite"
#gcost 8
#end
-- Ermorian

#selectmonster 684
#name "Velite"
#gcost 8
#end
-- Pythian

#selectmonster 708
#name "Reveler"
#gcost 11
#prot 2
#end

#selectmonster 721
#name "Unproven Warrior"
#descr "The Warriors of the Mictlan army wield spears, hide shields, and unsophisticated ranged weapons such as javelins and slings.  While most wear heavy, crude armor made of leather, wood, and bone, unproven Warriors of common descent are often sent to battle unarmored.  Their low survivability is partially compensated for by increased mobility."
#gcost 5
#att 9
#def 9
#forestsurvival
#end

#selectmonster 726
#name "Eagle Warrior"
#gcost 15
#mr 11
#end

#selectmonster 727
#name "Jaguar Warrior"
#gcost 16
#hp 13
#prot 1
#mr 11
#end
-- default cost 20

-- *** NOTE! For some reason this gets a "claw" attack - try clearspec
-- note that they only regenerate in jaguar form
#selectmonster 728
#clear
#name "Were Jaguar"
#descr "A Were Jaguar is a transformed Jaguar Warrior: half beast, half man. Were Jaguars regenerate and are ferocious fighters, though they are neither as large or stealthy as true jaguars. They are sacred to the Mictlan people."
#hp 18
#prot 5
#mor 15
#mr 12
#enc 2
#str 15
#att 12
#def 12
#prec 5
#ap 16
#mapmove 2
#holy
#regeneration 1
#forestsurvival
#weapon "Shred"
#weapon "Crushing Bite"
#firstshape 727
#end

#selectmonster 729
#name "Mictlan Scout"
#descr "Mictlan Scouts are trained to pass unseen through enemy territory, and are especially adept at jungle traversal. Their reports on enemy army movements and on the resources in enemy lands are invaluable to the prudent warlord."
#gcost 20
#rcost 1
#prec 11
#forestsurvival
#stealthy 5
#end

-- Engineers are very precise, and always carry a compass and ruler
#selectmonster 748
#name "Siege Engineer"
#gcost 50
#rcost 50
#prec 11
#hp 11
#weapon 901
#weapon 902
#end

#selectmonster 770
#name "White Satyr"
#prot 2
#end

#selectmonster 783
#name "Serpent Dancer"
#gcost 20
#mor 12
#end

#selectmonster 784
#name "Jotun Woodsman"
#gcost 45
#rcost 11
#hp 33
#mor 14
#def 12
#end

#selectmonster 786
#name "Jotun Scout"
#prec 11
#def 12
#end

#selectmonster 794
#name "Pike Footman"
#descr "Soldiers of T'ien Ch'i equip polearms and wear armor of leather and linen."
#gcost 8
#end

#selectmonster 795
#name "Glaive Footman"
#descr "Soldiers of T'ien Ch'i equip polearms and wear armor of leather and linen."
#gcost 8
#end

-- Only 1 strat move makes them bad, despite being more
-- expensive than other holy-3 priests.
#selectmonster 804
#name "Minister of Rituals"
#gcost 85
#end

#selectmonster 805
#name "Eunuch"
#descr "Eunuchs are widely used in the Imperial burueacracy as they do not nurture dynastic ambitions. Most Eunuchs are adminstrators and ministers, but some are trained in martial arts and given armies to lead."
#gcost 25
#rcost 1
#mor 11
#att 11
#def 11
#enc 4
#ambidextrous 2
#weapon "Punch"
#weapon "Kick"
#end

-- Only 1 strat move makes them REALLY bad.
#selectmonster 807
#name "Ceremonial Master"
#gcost 40
#end

#selectmonster 809
#name "Shadow Vestal"
#enc 1
#weapon "Shadow Spear"
#end
--cost unkn

-- Tien Chi
#selectmonster 813
#name "Imperial Consort"
#mor 12
#weapon "Slap"
#end

#selectmonster 853
#name "Skin Shifter"
#gcost 17
#hp 15
#prot 1
#mr 12
#mor 13
#att 11
#def 11
#coldres 25
#end
--cost too high?
--Midgard shifter

-- god jaguar
#selectmonster 858
#name "Jaguar"
#weapon "Shred"
#weapon "Crushing Bite"
#swampsurvival
#str 17
#size 3
#stealthy 10
#end

-- animal jaguar
#selectmonster 859
#name "Jaguar"
#weapon "Shred"
#weapon "Crushing Bite"
#swampsurvival
#str 16
#att 15
#def 12
#size 3
#stealthy 10
#end

#selectmonster 870
#name "Pirate Captain"
#descr "Having risen through the bloodthirsty ranks of seafaring hooligans, Pirate leaders are well-equipped and experienced.  They are especially effective at pillaging, and often wear an eyepatch as an aesthetic device whilst spinning salty yarns.  They are capable of sailing across oceans with troops."
#eyes 1
#weapon "Falchion"
#weapon "Hook"
#armor "Eyepatch"
#armor "Ring Mail Cuirass"
#prec 7
#str 11
#ambidextrous 3
#pillagebonus 5
#end

#selectmonster 871
#name "Pirate"
#pillagebonus 2
#end

#selectmonster 880
#name "Machaka Warrior"
#gcost 6
#end

#selectmonster 967
#name "Deformed Hybrid"
#descr "The Hybrid is a strange cross between a human and a Deep One.  This being is usually the result of a human female, a Deep One, and the influences of Ryleh, though some have been born as a result of tentacle monsters sneaking into cosplay parties.  The Deformed Hybrid has a high magic resistance but is not very effective in combat."
#mr 13
#gcost 6
#end
--cost unkn.  Has 1 tentacle, no other limbs

#selectmonster 968
#name "Tentacle Hybrid"
#descr "The Hybrid is a strange cross between a human and a Deep One.  This being is usually the result of a human female, a Deep One, and the influences of Ryleh, though some have been born as a result of tentacle monsters sneaking into cosplay parties.  Weak in actual combat, Tentacle Hybrids often migrate to the islands off T'ien Ch'i and terrorize local schoolchildren."
#gcost 7
#end
--cost unkn, 2 tentacles

#selectmonster 969
#name "Hybrid Clubber"
#descr "The Hybrid is a strange cross between a human and a Deep One.  This being is usually the result of a human female, a Deep One, and the influences of Ryleh.  Some of the more successful spawns of these unions, Hybrid Clubbers are armed, armored, and sent to war."
#gcost 8
#ambidextrous 4
#end
--cost unkn

#selectmonster 970
#name "Hybrid Trooper"
#gcost 9
#ambidextrous 4
#end
--cost unkn

#selectmonster 974
#name "Ichtyid"
#gcost 8
#end

#selectmonster 993
#name "Slave of Belphegor"
#gcost 0
#end

-- lowered price because wolves are really, really weak.
#selectmonster 1028
#name "Wolfherd"
#gcost 40
#hp 12
#enc 2
#att 11
#def 11
#prec 11
#animalawe 1
#end

#selectmonster 1041
#name "Ichtysatyr"
#gcost 8
#rcost 2
#end
-- aquatic (Oceania)

#selectmonster 1042
#name "Ichtysatyr"
#gcost 8
#rcost 2
#end
-- land (Oceania)

#selectmonster 1046
#name "Merman"
#gcost 8
#rcost 3
#end
-- aquatic (Oceania)

#selectmonster 1047
#name "Merman"
#gcost 8
#rcost 3
#end
-- land (Oceania)

#selectmonster 1050
#name "Merman Captain"
#rcost 3
#end
-- aquatic (Oceania)

#selectmonster 1051
#name "Merman Captain"
#rcost 3
#end
-- land (Oceania)

#selectmonster 1056
#name "Oceanian Triton"
#gcost 8
#rcost 2
#end
-- aquatic

--sea dog
#selectmonster 1064
#end
-- amphi (unknown origin)

#selectmonster 1065
#name "Merman"
#gcost 8
#end
-- aquatic (Indy)

#selectmonster 1066
#name "Merman"
#gcost 8
#end
-- land (Indy)

#selectmonster 1067
#name "Merman Captain"
#end
-- aquatic (Indy)

#selectmonster 1068
#name "Merman Captain"
#end
-- land (Indy)

#selectmonster 1072
#name "Engineer"
#weapon "Ruler"
#weapon "Compass"
#armor "Pocket Protector"
#end
-- Golden Age Arco



































-- Medium Infantry, ~9-12 prot, guideline: 9g

#selectmonster 29
#name "Medium Javelin Infantry"
#descr "Equipped with light armor, shields, and spears, these soldiers are quick but somewhat vulnerable to missile weapons.  They sometimes carry javelins."
#gcost 9
#end

#selectmonster 38
#name "Medium Infantry"
#descr "Equipped with light armor, shields, and spears, these soldiers are quick but somewhat vulnerable to missile weapons.  They sometimes carry javelins."
#gcost 9
#end

#selectmonster 52
#name "Battle Deacon"
#gcost 70
#end
-- Man

#selectmonster 61
#name "Spearman"
#gcost 8
#end
-- Man

#selectmonster 62
#name "Longspear"
#gcost 9
#end
-- Man

#selectmonster 107
#name "Reef Warrior"
#gcost 10
#end
-- Atlantis.  Cost too low?  It has spiky armor and amphibious..

#selectmonster 130
#name "Caelian Light Infantry"
#gcost 11
#rcost 11
#end

-- gave +1 attack to reflect "higher combat skills" than other caelians
-- and justify higher price than normal spire horn warriors
#selectmonster 131
#name "Spire Horn Warrior"
#gcost 11
#rcost 8
#att 11
#end

#selectmonster 142
#name "Huskarl"
#gcost 9
#end
--axe, Van

#selectmonster 143
#name "Huskarl"
#gcost 9
#end
--spear, Van

#selectmonster 146
#name "Einhere"
#hp 13
#prec 9
#ambidextrous 3
#end

#selectmonster 166
#name "City Guard"
#gcost 9
#end

-- Abyssian Salamander.  
-- rcost increased to reflect effort in training them
-- gcost reduced due to low survivability and lack of salary
-- hp increased to improve survivability
-- att increased (within the weapon) because
-- the AOE flare should be very hard or impossible to dodge
#selectmonster 213
#name "Salamander"
#gcost 55
#rcost 4
#hp 21
#end

#selectmonster 219
#name "Swordsman"
#gcost 9
#end

#selectmonster 220
#name "Halberdier"
#gcost 9
#end

#selectmonster 221
#name "Pikeneer"
#gcost 9
#end

#selectmonster 275
#name "Jotun Gode"
#gcost 200
#rcost 18
#mr 15
#end

-- higher precision due to training and visibility
#selectmonster 276
#name "Jotun Javelinist"
#gcost 30
#prec 11
#end

#selectmonster 336
#name "Slave Guardian"
#gcost 9
#enc 3
#end

#selectmonster 351
#name "Garnet Amazon"
#descr "Amazons are a people of semi-civilized tribes ruled by women.  The Amazonian culture is centered around warfare and prowess in combat. Their people are comprised of four tribes - Crystal, Garnet, Onyx, and Jade - led by Sorceresses and Priestess trained in magic. Garnet Amazons are said to have sprund from an early breeding experiment of the Warlocks of the Smouldercone. They are immune to fire and use Blood and Fire magic as the Abysians do. Garnet Amazons are more aggressive and arrogant than other tribes."
#gcost 12
#end

#selectmonster 354
#name "Jade Amazon"
#descr "Amazons are a people of semi-civilized tribes ruled by women. The Amazonian culture is centered around warfare and prowess in combat. Their people are comprised of four tribes - Crystal, Garnet, Onyx, and Jade - led by Sorceresses and Priestess trained in magic. The Jade Amazons are known for their skill in magic, and their warriors often ride giant bipedal lizards into battle."
#gcost 10
#end

#selectmonster 372
-- name "Humanbred Spear Infantry"
#name "Humanbred"
#gcost 12
#end
-- Abysia Default

-- underpaid because they are scorned
#selectmonster 414
#name "Wingless"
#gcost 9
#end

#selectmonster 420
#name "Caelian Infantry"
#gcost 12
#end

-- Vanheim hero
#selectmonster 544
#name "Einhere"
#end

-- Jotun god
-- changed to reflect changes in Niefel units
#selectmonster 605
#name "Son of Niefel"
#att 13
#armor "Mammoth Leather Armor"
#armor "Ice Aegis"
#end

#selectmonster 722
#name "Warrior"
#descr "The Warriors of the Mictlan army wield spears, hide shields, and unsophisticated ranged weapons such as javelins and slings.  Most wear heavy, crude armor made of leather, wood, and bone, often adorned with feathers.  Feathered plumed helmets are worn by more prominent fighters.  Since the development of copper working, some experienced Warriors are honored with copper scaled mail."
#gcost 7
#end

#selectmonster 723
#name "Warrior"
#descr "The Warriors of the Mictlan army wield spears, hide shields, and unsophisticated ranged weapons such as javelins and slings.  Most wear heavy, crude armor made of leather, wood, and bone, often adorned with feathers.  Feathered plumed helmets are worn by more prominent fighters.  Since the development of copper working, some experienced Warriors are honored with copper scaled mail."
#gcost 7
#end

#selectmonster 724
#name "Honored Warrior"
#descr "The Warriors of the Mictlan army wield spears, hide shields, and unsophisticated ranged weapons such as javelins and slings.  Most wear heavy, crude armor made of leather, wood, and bone, often adorned with feathers.  Feathered plumed helmets are worn by more prominent fighters.  Since the development of copper working, some experienced Warriors are honored with copper scaled mail."
#gcost 8
#mor 11
#att 11
#end
//mictlan, copper scale.  Copper is expensive

#selectmonster 725
#name "Sun Warrior"
#gcost 16
#str 11
#mr 11
#prec 11
#end
//mictlan

#selectmonster 730
#name "Tribal King"
#gcost 40
#prec 11
#end

#selectmonster 796
#name "Spear Footman"
#descr "Soldiers of T'ien Ch'i equip polearms and wear armor of leather and linen."
#gcost 9
#end

#selectmonster 799
#name "Imperial Glaive Footman"
#descr "The skilled Imperial soldiers are heavily armed and trained by officials of the bureaucracy.  The training focuses on control of emotions, and all Imperial soldiers have outstanding morale.  Imperial Footmen wear scale armor and use spears or glaives."
#gcost 11
#rcost 18
#att 11
#def 11
#end

#selectmonster 837
#name "Huskarl"
#gcost 9
#end
--Jotun, axe

#selectmonster 838
#name "Huskarl"
#gcost 9
#end
--Jotun, spear

-- Huskarls are handpicked, so should be slightly better in combat than normal...
#selectmonster 840
#name "Jotun Huskarl"
#gcost 35
#att 11
#hp 31
#end
-- axe

#selectmonster 841
#name "Jotun Huskarl"
#gcost 35
#att 11
#hp 31
#end
-- spear

-- Shouldn't their attack be as good as a woodsman??
#selectmonster 845
#name "Niefel Giant"
#gcost 150
#rcost 40
#str 24
#att 12
#weapon "Niefel Axe"
#weapon "Kick"
#armor "Helmet"
#armor "Mammoth Leather Armor"
#armor "Round Shield"
#end

#selectmonster 849
#name "Daoine Sidhe"
#gcost 35
#rcost 18
#armor "Bronze Chain Cuirass"
#armor "Bronze Helmet"
#armor "Round Shield"
#end

#selectmonster 855
#name "Valkyrie"
#gcost 70
#rcost 16
#weapon "Soul Spear"
#end
-- Helheim

#selectmonster 860
#name "Feathered Warrior"
#gcost 17
#str 11
#mor 12
#hp 11
#prec 11
#end

#selectmonster 928
#name "Heavy Glaive Footman"
#descr "Throughout the history of the Celestial Empire, the training of Footmen has never been as efficient as during the reign of the bureaucracy. The Heavy Footmen of the time of Spring and Autumn wear scale armor and use spears or glaives, but their morale is slightly lower than the Imperial Footmen of the the bureaucracy."
#gcost 9
#end

#selectmonster 949
#name "Raven Guard"
-- cost unkn
#end

#selectmonster 971
#name "Hybrid Soldier"
#gcost 11
#end
--cost unkn

#selectmonster 971
#name "Hybrid Lord"
#end
--cost unkn

#selectmonster 975
#name "Ichtyid Warrior"
#gcost 10
#end

#selectmonster 976
#name "Ichtyid Lord"
#gcost 30
#def 9
#att 11
#hp 13
#end

#selectmonster 983
-- name "Humanbred Axe Infantry"
#name "Humanbred"
#gcost 12
#end
-- Abysian default

#selectmonster 984
-- name "Abysian Light Spear Infantry"
#name "Abysian Light Infantry"
#gcost 10
#rcost 11
#end
--BoH

#selectmonster 985
-- name "Abysian Light Axe Infantry"
#name "Abysian Light Infantry"
#gcost 10
#rcost 12
#end
--BoH

#selectmonster 1013
#name "Ulm Pikeneer"
#descr "The Pikeneers of Ulm are armed with long pikes. The secrets of Blacksteel are forgotten since the Malediction, but normal plate cuirasses are still used. The inhabitants of Ulm are large and can endure much physical punisment before collapsing, but are vulnerable to magic."
#gcost 9
#enc 2
#hp 12
#str 11
#end
--black Forest

#selectmonster 1014
#name "Ulm Halberdier"
#descr "The Halberdiers of Ulm are armed with heavy halberds. The secrets of Blacksteel are forgotten since the Malediction, but normal plate cuirasses are still used. Each Halberdier counts as two men when defending besieged castles. The inhabitants of Ulm are large and can endure much physical punisment before collapsing, but are vulnerable to magic."
#gcost 9
#enc 2
#hp 12
#str 11
#end
--Black Forest

#selectmonster 1048
#name "Wave Warrior"
#gcost 11
#rcost 19
#end
-- aquatic (Oceania)

#selectmonster 1049
#name "Wave Warrior"
#gcost 11
#rcost 19
#end
-- land (Oceania)

#selectmonster 1082
#name "Icarid"
#gcost 18
#rcost 28
#weapon "Bronze Short Sword"
#armor "Bronze Full Helmet"
#armor "Icarian Wings"
#armor "Round Shield"
#end
-- Golden Era

#selectmonster 1083
#name "Icarid Champion"
#gcost 50
#rcost 28
#weapon "Bronze Short Sword"
#armor "Bronze Full Helmet"
#armor "Icarian Wings"
#armor "Round Shield"
#end
-- Golden Era

#selectmonster 1094
#name "Desert Ranger"
#gcost 13
#rcost 16
#fireres 25
#end
-- Ctis Tombs

#selectmonster 1097
#name "Turtle Warrior"
#gcost 10
#rcost 9
#end
-- aquatic (Oceania)

#selectmonster 1098
#name "Turtle Warrior"
#gcost 10
#rcost 9
#end
-- land (Oceania)

#selectmonster 1099
#name "Turtle Captain"
#gcost 35
#rcost 9
#end
-- aquatic (Oceania)

#selectmonster 1100
#name "Turtle Captain"
#gcost 35
#rcost 9
#end
-- land (Oceania)


































-- heavy infantry, ~13-15 prot

#selectmonster 16
#name "Hypaspist Commander"
#gcost 45
#rcost 21
#end

#selectmonster 16
#name "Hypaspist"
#gcost 15
#rcost 21
#prec 9
#mor 12
#end

#selectmonster 39
#name "Heavy Infantry"
#gcost 10
#prec 9
#end

#selectmonster 40
#name "Heavy Infantry"
#gcost 10
#end

#selectmonster 53
#name "Axeman"
#gcost 10
#prec 9
#end
--man

#selectmonster 54
#name "Castellan"
#gcost 30
#rcost 20
#att 12
#def 12
#end

#selectmonster 63
#name "Tower Guard"
#gcost 12
#rcost 17
#mor 12
#prec 9
#end

#selectmonster 81
#name "Abysian Battleaxe Infantry"
#descr "The Abysians are a race of hellish humans with magma bodies. The radiate a furnacelike heat and are impervious to all forms of fire, but are vulnerable to cold. The chill of winter slows them down and lowers their morale. Abysian Infantry use heavy iron armor and heavy weapons that will not burn away in their smouldering hands."
#gcost 20
#att 11
#coldres -25
#end

#selectmonster 82
#name "Abysian Flail Infantry"
#descr "The Abysians are a race of hellish humans with magma bodies. The radiate a furnacelike heat and are impervious to all forms of fire, but are vulnerable to cold. The chill of winter slows them down and lowers their morale. Abysian Infantry use heavy iron armor and heavy weapons that will not burn away in their smouldering hands."
#gcost 20
#att 11
#coldres -25
#end

#selectmonster 108
#name "Coral Guard"
#gcost 15
#str 11
#prec 7
#end

--Abysia commander - prophet version?
#selectmonster 118
#name "War Master"
#ambidextrous 5
#def 13
#enc 2
#coldres -25
#end

--Abysia commander
#selectmonster 119
#name "Warlord"
#gcost 60
#rcost 26
#enc 2
#coldres -25
#end

-- marignon elite
#selectmonster 133
#name "Man at Arms"
#gcost 13
#prec 9
#armor "Helmet"
#armor "Gilded Chain Hauberk"
#armor "Round Shield"
#end

-- vanheim, spear
#selectmonster 144
#name "Hirdman"
#gcost 12
#rcost 18
#prec 9
#end

-- vanheim, sword
#selectmonster 145
#name "Hirdman"
#gcost 12
#rcost 20
#prec 9
#end

#selectmonster 163
#name "Commander of C'tis"
#gcost 40
#rcost 16
#end

-- c'tis capitol only elite
#selectmonster 164
#name "Swamp Guard"
#gcost 13
#rcost 22
#str 11
#prec 9
#end

#selectmonster 165
#name "C'tis Heavy Infantry"
#gcost 10
#prec 9
#end

#selectmonster 209
#name "Mother Guard"
#gcost 60
#rcost 27
#mr 11
#prec 7
#end

--Abysia commander
#selectmonster 214
#name "Beast Trainer"
#gcost 65
#rcost 26
#att 11
#enc 2
#coldres -25
#end

#selectmonster 441
#name "Consort"
#gcost 80
#rcost 27
#end

#selectmonster 230
#name "Satyr Hoplite"
#gcost 12
#rcost 23
#prot 2
#armor "Bronze Helmet"
#armor "Bronze Cuirass"
#armor "Round Shield"
#end

#selectmonster 243
#name "Crab Hybrid"
#gcost 32
#rcost 1
#hp 26
#prec 4
#ambidextrous 4
#end

#selectmonster 261
#name "Valkyrie"
#gcost 70
#rcost 16
#weapon "Soul Spear"
#coldres 25
#end
--Default Vanheim

#selectmonster 271
#name "Burgmeister Guard"
#gcost 8
#rcost 12
#str 7
#prec 10
#mor 9
#end
-- gcost unkn

#selectmonster 272
#name "Hoburg Champion"
#gcost 25
#rcost 12
#str 7
#prec 10
#mor 10
#end

#selectmonster 274
#name "Jotun Jarl"
#gcost 130
#rcost 34
#mr 14
#end

-- Jotun spear is 1r cheaper than jotun axe
#selectmonster 278
#name "Jotun Spearman"
#gcost 30
#rcost 31
#end

#selectmonster 279
#name "Jotun Axeman"
#gcost 30
#rcost 32
#end

#selectmonster 285
#name "Mercenary Hammer Infantry"
#descr "Mercenaries have good armaments and some experience."
#prec 9
#end

#selectmonster 286
#name "Mercenary Swordsman"
#descr "Mercenaries have good armaments and some experience."
#prec 9
#end

#selectmonster 287
#name "Mercenary Spearman"
#descr "Mercenaries have good armaments and some experience."
#prec 9
#end

#selectmonster 288
#name "Mercenary Morningstar Infantry"
#descr "Mercenaries have good armaments and some experience. Morningstar users are especially effective against troops carrying shields."
#prec 9
#end

#selectmonster 289
#name "Mercenary Pikeneer"
#descr "Mercenaries have good armaments and some experience."
#end

#selectmonster 291
#name "Mercenary Captain"
#descr "The commander of a mercenary band, he is well-equipped and experienced."
#prec 9
#end

#selectmonster 357
#name "Onyx Amazon"
#descr "Amazons are a people of semi-civilized tribes ruled by women. The Amazonian culture is centered around warfare and prowess in combat. Their people are comprised of four tribes - Crystal, Garnet, Onyx, and Jade - led by Sorceresses and Priestess trained in magic. The Onyx Amazons use heavier armors than the other tribes."
#prec 11
#gcost 11
#end
--cost unkn
--raise str?

#selectmonster 407
#name "Illithid Soldier"
#gcost 55
#rcost 22
#hp 29
#mor 11
#att 11
#def 7
#end

#selectmonster 421
#name "Storm Guard"
#gcost 14
#prec 10
#end

-- vanheim leader
#selectmonster 422
#name "Herse"
#gcost 30
#rcost 20
#end

-- normal assassins are trained to +3 att/def above normal,
-- so Slayers should be as well...
#selectmonster 429
#name "Slayer"
#gcost 80
#rcost 10
#prec 8
#enc 2
#att 14
#def 13
#coldres -25
#end

#selectmonster 445
#name "Illithid Lord"
#gcost 80
#rcost 22
#str 16
#att 12
#def 9
#end

#selectmonster 577
#name "Triton Trooper"
#gcost 12
#att 11
#hp 11
#prec 9
#end

#selectmonster 663
#name "Alae Legionnaire"
#gcost 11
#rcost 19
#end

#selectmonster 664
#name "Hastatus"
#gcost 12
#rcost 20
#end

#selectmonster 665
#name "Principe"
#gcost 15
#rcost 20
#end

#selectmonster 682
#name "Ermorian Standard"
#descr "Standard Bearers are prominent soldiers entrusted with the care of a standard. Standards are important to the morale of the legions, and their presence will strengthen the spirits of nearby soldiers."
#gcost 20
#rcost 19
#att 11
#def 11
#mor 11
#end

#selectmonster 685
#name "Alae Legionnaire"
#gcost 11
#rcost 19
#end

#selectmonster 686
#name "Hastatus"
#gcost 12
#rcost 20
#end

#selectmonster 687
#name "Principe"
#gcost 15
#rcost 20
#end

-- Pythium Standard
#selectmonster 689
#name "Pythian Standard"
#descr "Standard Bearers are prominent soldiers entrusted with the care of a standard. Standards are important to the morale of the legions, and their presence will strengthen the spirits of nearby soldiers."
#gcost 20
#rcost 19
#att 11
#def 11
#mor 11
#end

#selectmonster 697
#name "Satyr Hoplite"
#gcost 13
#rcost 20
#str 12
#prot 2
#end
--iron age

#selectmonster 798
#name "Imperial Guard"
#gcost 15
#rcost 21
#att 12
#def 12
#mor 14
#hp 11
#str 11
#weapon "Imperial Dao"
#end

#selectmonster 800
#name "Imperial Spear Footman"
#descr "The skilled Imperial soldiers are heavily armed and trained by officials of the bureaucracy.  The training focuses on control of emotions, and all Imperial soldiers have outstanding morale.  Imperial Footmen wear scale armor and use spears or glaives."
#gcost 11
#rcost 18
#att 11
#def 11
#end

#selectmonster 839
#name "Herse"
#gcost 30
#end
--Jotun human herse

#selectmonster 842
#name "Jotun Hirdman"
#gcost 40
#rcost 34
#hp 32
#end


#selectmonster 929
#name "Heavy Spear Footman"
#descr "Throughout the history of the Celestial Empire, the training of Footmen has never been as efficient as during the reign of the bureaucracy. The Heavy Footmen of the time of Spring and Autumn wear scale armor and use spears or glaives, but their morale is slightly lower than the Imperial Footmen of the the bureaucracy."
#gcost 10
#prec 9
#end

#selectmonster 989
#name "Abysian Flail Infantry"
#descr "Human blood has grown strong in the Abysian society, and the Halfbreeds are no longer mere slaves. Now most of the army consists of Humanbreds since the pure Abysians are dwindling in number. The Heavy Infantry use the traditional metal armor and heavy weapons of Abysia."
#gcost 11
#rcost 27
#str 12
#end

#selectmonster 988
#name "Abysian Battleaxe Infantry"
#descr "Human blood has grown strong in the Abysian society, and the Halfbreeds are no longer mere slaves. Now most of the army consists of Humanbreds since the pure Abysians are dwindling in number. The Heavy Infantry use the traditional metal armor and heavy weapons of Abysia."
#gcost 11
#rcost 28
#str 12
#end

#selectmonster 992
#name "Abysian Commander"
#gcost 35
#rcost 25
#str 12
#end

#selectmonster 1015
#name "Ulm Morningstar Infantry"
#descr "The Infantry of Ulm carry heavy tower shields and morningstars, which are especially effective against shielded enemies. The secrets of Blacksteel are forgotten since the Malediction, but normal plate cuirasses are still used. The inhabitants of Ulm are large and can endure much physical punisment before collapsing, but are vulnerable to magic."
#gcost 10
#hp 12
#str 11
#enc 2
#end
--Black Forest

#selectmonster 1016
#name "Commander of Ulm"
#descr "The Commanders of Ulm carry heavy tower shields and wield broad swords. The secrets of Blacksteel are forgotten since the Malediction, but normal plate cuirasses are still used. The inhabitants of Ulm are large and can endure much physical punisment before collapsing, but are vulnerable to magic."
#gcost 30
#rcost 24
#hp 13
#str 12
#att 11
#def 11
#mor 12
#enc 2
#goodleader
#end
--Black Forest

#selectmonster 1043
#name "Ichtysatyr Soldier"
#gcost 11
#rcost 19
#end
-- aquatic (Oceania)

#selectmonster 1044
#name "Ichtysatyr Soldier"
#gcost 11
#rcost 19
#end
-- land (Oceania)

#selectmonster 1057
#name "Oceanian Soldier"
#gcost 10
#rcost 19
#end
-- aquatic (Oceania)

#selectmonster 1069
#name "Oceanian Captain"
#gcost 30
#rcost 19
#end
-- aquatic (Oceania)




































--Superheavy: 16+ protection.  guideline: 11g for non-elite


-- What justification is there for mr 12?
-- Even 11 seems odd, but oh well...
#selectmonster 6
#name "Emerald Lord"
#mr 11
#end

#selectmonster 7
#name "Emerald Guard"
#gcost 25
#end

#selectmonster 13
#name "Hoplite Commander"
#gcost 40
#prec 9
#end

#selectmonster 14
#name "Hoplite"
#gcost 13
#mor 11
#prec 8
#end

#selectmonster 65
#name "Warden of Avalon"
#gcost 40
#prec 8
#end

#selectmonster 66
#name "Guardian"
#gcost 20
#rcost 36
#att 12
#def 12
#str 13
#hp 15
#prec 8
#enc 2
#weapon "Black Steel Halberd"
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#end

#selectmonster 67
#name "Ulm Battleaxe Infantry"
#descr "The Heavy Infantry units of Ulm are clad in chain mail armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. They are the strongest standard human infantry units available. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#gcost 10
#rcost 22
#hp 12
#str 11
#prec 9
#mr 9
#enc 2
#mapmove 1
#weapon "Battleaxe"
#armor "Full Chain Mail of Ulm"
#armor "Helmet"
#end

-- Note:  Ulm Black Plate units all get +1 morale because they are
-- bigger and stronger than normal humans, and feel invulnerable with all that armor
-- Cost went up +1 to compensate
#selectmonster 68
#name "Black Plate Infantry"
#descr "The Black Plate Infantry of Ulm are clad in full plate armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. They are the strongest standard human infantry units available. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#gcost 11
#rcost 34
#str 11
#mor 11
#hp 13
#prec 8
#enc 2
#weapon "Battleaxe"
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#end

#selectmonster 71
#name "Ulm Flail Infantry"
#descr "The Heavy Infantry units of Ulm are clad in chain mail armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. They are the strongest standard human infantry units available. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#gcost 10
#rcost 22
#hp 12
#str 11
#prec 9
#mr 9
#enc 2
#mapmove 1
#weapon "Flail"
#armor "Full Chain Mail of Ulm"
#armor "Helmet"
#end

#selectmonster 72
#name "Black Plate Infantry"
#descr "The Black Plate Infantry of Ulm are clad in full plate armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. They are the strongest standard human infantry units available. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#gcost 11
#rcost 34
#str 11
#mor 11
#hp 13
#prec 8
#enc 2
#weapon "Flail"
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#end

#selectmonster 73
#name "Ulm Hammer Infantry"
#descr "The Heavy Infantry units of Ulm are clad in chain mail armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. They are the strongest standard human infantry units available. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#gcost 10
#rcost 24
#hp 12
#str 11
#prec 9
#mr 9
#enc 2
#mapmove 1
#weapon "Hammer"
#armor "Full Chain Mail of Ulm"
#armor "Helmet"
#armor "Tower Shield"
#end

#selectmonster 74
#name "Black Plate Infantry"
#descr "The Black Plate Infantry of Ulm are clad in full plate armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. They are the strongest standard human infantry units available. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#gcost 11
#rcost 36
#str 11
#mor 11
#hp 13
#prec 8
#enc 2
#weapon "Hammer"
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#armor "Tower Shield"
#end

#selectmonster 75
#name "Ulm Maul Infantry"
#descr "The Heavy Infantry units of Ulm are clad in chain mail armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. They are the strongest standard human infantry units available. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#gcost 10
#rcost 21
#hp 12
#str 11
#prec 9
#mr 9
#enc 2
#mapmove 1
#weapon "Maul"
#armor "Full Chain Mail of Ulm"
#armor "Helmet"
#end

-- Maul
#selectmonster 76
#name "Black Plate Infantry"
#descr "The Black Plate Infantry of Ulm are clad in full plate armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. They are the strongest standard human infantry units available. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#gcost 11
#rcost 33
#str 11
#mor 11
#hp 13
#prec 8
#enc 2
#weapon "Maul"
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#end

#selectmonster 77
#name "Ulm Morningstar Infantry"
#descr "The Morningstar Infantry of Ulm are clad in black steel chain mail and carry tower shields. They are the strongest standard human infantry units available. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic. Morningstar Infantry are especially effective against shielded enemies."
#gcost 10
#rcost 25
#hp 12
#str 11
#prec 9
#mr 9
#enc 2
#mapmove 1
#weapon "Morningstar"
#armor "Full Chain Mail of Ulm"
#armor "Helmet"
#armor "Tower Shield"
#end

#selectmonster 78
#name "Black Plate Infantry"
#descr "The Black Plate Infantry of Ulm are clad in full plate armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. They are the strongest standard human infantry units available. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic. Morningstar Infantry are especially effective against shielded enemies."
#gcost 11
#rcost 37
#str 11
#mor 11
#hp 13
#prec 8
#enc 2
#weapon "Morningstar"
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#end

#selectmonster 79
#name "Ulm Pikeneer"
#descr "The Pikeneers of Ulm are armed with long pikes and clad in chain mail armor made from the black steel of Ulm. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#gcost 10
#rcost 22
#hp 12
#str 11
#prec 9
#mr 9
#enc 2
#mapmove 1
#weapon "Pike"
#armor "Full Chain Mail of Ulm"
#armor "Helmet"
#end

#selectmonster 80
#name "Black Plate Pikeneer"
#descr "The Black Plate Pikeneers of Ulm are armed with long pikes and clad in full plate armor made from the black steel of Ulm. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#gcost 11
#rcost 33
#str 11
#mor 11
#hp 13
#prec 8
#enc 2
#weapon "Pike"
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#end

#selectmonster 83
#name "Abysian Axe Infantry"
#descr "The Abysians are a race of hellish humans with magma bodies. The radiate a furnacelike heat and are impervious to all forms of fire, but are vulnerable to cold. The chill of winter slows them down and lowers their morale. Abysian Infantry use heavy iron armor and heavy weapons that will not burn away in their smouldering hands."
#gcost 20
#rcost 28
#att 11
#coldres -25
#end

#selectmonster 84
#name "Abysian Morningstar Infantry"
#descr "The Abysians are a race of hellish humans with magma bodies. The radiate a furnacelike heat and are impervious to all forms of fire, but are vulnerable to cold. The chill of winter slows them down and lowers their morale. Abysian Infantry use heavy iron armor and heavy weapons that will not burn away in their smouldering hands. Morningstar users are especially effective against troops carrying shields."
#gcost 20
#rcost 30
#att 11
#coldres -25
#end

#selectmonster 90
#name "Lava Warrior"
#gcost 55
#rcost 30
#hp 18
#att 12
#def 11
#enc 8
#mr 13
#coldres -25
#end

#selectmonster 113
#name "Lord Guardian"
#gcost 60
#rcost 36
#def 13
#weapon "Black Steel Halberd"
#armor "Full Plate of Ulm"
#armor "Full Helmet of Ulm"
#end

#selectmonster 114
#name "Commander of Ulm"
#descr "The Commanders of Ulm are clad in thick armor made from the black steel of Ulm chain mail armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. Their impressive blue-tassled helmets inspire loyalty, allowing the command of more troops compared to normal humans. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#goodleader
#gcost 30
#rcost 24
#hp 14
#mor 12
#mr 9
#enc 2
#str 11
#att 11
#def 11
#prec 10
#ap 12
#mapmove 2
#weapon "Hammer"
#armor "Full Chain Mail of Ulm"
#armor "Helmet"
#armor "Tower Shield"
#end

#selectmonster 115
#name "Commander of Ulm"
#descr "The Commanders of Ulm are clad in thick armor made from the black steel of Ulm chain mail armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. Their impressive blue-tassled helmets inspire loyalty, allowing the command of more troops compared to normal humans. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#goodleader
#gcost 30
#rcost 36
#hp 14
#mor 12
#mr 9
#enc 2
#str 11
#att 11
#def 11
#prec 10
#ap 12
#mapmove 2
#weapon "Hammer"
#armor "Full Plate of Ulm"
#armor "Full Helmet of Ulm"
#armor "Tower Shield"
#end

#selectmonster 116
#name "Commander of Ulm"
#descr "The Commanders of Ulm are clad in thick armor made from the black steel of Ulm chain mail armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. Their impressive blue-tassled helmets inspire loyalty, allowing the command of more troops compared to normal humans. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#goodleader
#gcost 30
#rcost 25
#hp 14
#mor 12
#mr 9
#enc 2
#str 11
#att 11
#def 11
#prec 10
#ap 12
#mapmove 2
#weapon "Morningstar"
#armor "Full Chain Mail of Ulm"
#armor "Helmet"
#armor "Tower Shield"
#end

#selectmonster 117
#name "Commander of Ulm"
#descr "The Commanders of Ulm are clad in thick armor made from the black steel of Ulm chain mail armor made from the black steel of Ulm and are armed with heavy weapons and tower shields. Their impressive blue-tassled helmets inspire loyalty, allowing the command of more troops compared to normal humans. The inhabitants of Ulm are large and can endure much physical punishment before collapsing, but are vulnerable to magic."
#goodleader
#gcost 30
#rcost 37
#hp 14
#mor 12
#mr 9
#enc 2
#str 11
#att 11
#def 11
#prec 10
#ap 12
#mapmove 2
#weapon "Morningstar"
#armor "Full Plate of Ulm"
#armor "Full Helmet of Ulm"
#armor "Tower Shield"
#end

-- stat boost to reflect fact that "Spire Horn Warriors are often trained as Iceclads"
#selectmonster 132
#name "Iceclad"
#gcost 16
#rcost 43
#hp 10
#str 10
#prec 10
#end

#selectmonster 212
#name "Lord Warden"
#gcost 130
#rcost 27
#weapon "Black Steel Halberd"
#armor "Full Plate of Ulm"
#armor "Full Helmet of Ulm"
#end

#selectmonster 358
#name "Temple Guard"
#gcost 25
#rcost 43
#att 12
#prec 10
#mor 14
#end

#selectmonster 418
#name "Storm General"
#prec 10
#end

#selectmonster 424
#name "Meteorite Guard"
#gcost 11
#att 11
#prec 7
#enc 3
#end

#selectmonster 573
#name "Amber Clan Guard"
#prec 9
#att 12
#def 11
#end
--unkn

-- Ermor
#selectmonster 666
#name "Triarius"
#gcost 14
#rcost 28
#str 10
#prec 10
#end

-- Ermor
#selectmonster 667
#name "Praetorian Guard"
#gcost 14
#rcost 28
#str 10
#prec 9
#end

-- Pythium
#selectmonster 688
#name "Triarius"
#gcost 14
#prec 10
#end

-- Arco
#selectmonster 746
#name "Strategos"
#gcost 65
#rcost 28
#prec 10
#end

-- Pythium
#selectmonster 747
#name "Heart Companion"
#gcost 25
#rcost 28
#prec 8
#att 12
#mr 11
#end

#selectmonster 876
#name "Spider Warrior"
#descr "In the caves of the God Mountain, cultic assassins are trained by the Black Sorcerers. The Spider Warrior is not yet a fully trained assassin, but is skilled in stealth and melee combat."
#gcost 25
#rcost 36
#def 12
#prec 8
#mr 11
#weapon "Falchion"
#weapon "Poison Dagger"
#end

#selectmonster 877
#name "Bane Spider"
#gcost 150
#rcost 36
#def 13
#str 12
#mr 11
#end

#selectmonster 882
#name "Machaka Hoplite"
#gcost 12
#rcost 24
#str 11
#prec 9
#end

#selectmonster 883
#name "Machaka Commander"
#gcost 45
#rcost 24
#str 11
#end

-- Machaka
#selectmonster 952
#name "Hero"
#prot 1
#stealthy
#end

#selectmonster 986
name "Abysian Heavy Axe Infantry"
#descr "Human blood has grown strong in the Abysian society, and the Halfbreeds are no longer mere slaves. Now most of the army consists of Humanbreds since the pure Abysians are dwindling in number. The Heavy Infantry use the traditional metal armor and heavy weapons of Abysia."
#gcost 12
#rcost 28
#str 12
#end

#selectmonster 987
name "Abysian Heavy Morningstar Infantry"
#descr "Human blood has grown strong in the Abysian society, and the Halfbreeds are no longer mere slaves. Now most of the army consists of Humanbreds since the pure Abysians are dwindling in number. Abysian Morningstar Infantry wear traditional plate hauberks, and their morningstars are especially effective against shielded troops."
#gcost 12
#rcost 30
#str 12
#end

#selectmonster 990
#name "Guardian of the Pyre"
#gcost 55
#rcost 30
#att 12
#def 11
#mr 13
#end

#selectmonster 1020
#name "Ghoul Guardian"
#hp 16
#gcost 18
#rcost 35
#att 12
#def 12
#str 14
#prec 8
#mr 10
#weapon "Black Steel Halberd"
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#end

#selectmonster 1034
#name "Zweihander"
#gcost 11
#rcost 35
#hp 13
#mor 11
#str 12
#att 11
#def 11
#prec 8
#enc 2
#end

#selectmonster 1035
#name "Blood Marshal"
-- armor 91
#fear -2
#weapon "Full Plate of Ulm"
#end

#selectmonster 1045
#name "Mermidon"
#gcost 20
#rcost 27
#end
-- aquatic only (Oceania)

#selectmonster 1076
#name "Myrmidon Champion"
#gcost 35
#rcost 35
#weapon "Bronze Short Sword"
#armor "Bronze Full Helmet"
#armor "Bronze Hauberk"
#armor "Round Shield"
#end
-- Golden Era

#selectmonster 1077
#name "Myrmidon"
#gcost 14
#rcost 35
#weapon "Bronze Short Sword"
#armor "Bronze Full Helmet"
#armor "Bronze Hauberk"
#armor "Round Shield"
#end
-- Golden Era

#selectmonster 1096
#name "Tomb Guard"
#gcost 16
#rcost 29
#str 11
#enc 4
#prec 9
#fireres 25
#end
-- Ctis Tombs


























-- Void Gate Summons
-- Maybe they were already 0-upkeep, but this ensures it

#selectmonster 750
#gcost 0
#end

#selectmonster 751
#gcost 0
#end

#selectmonster 752
#gcost 0
#end

#selectmonster 753
#gcost 0
#end

#selectmonster 754
#gcost 0
#end

#selectmonster 755
#gcost 0
#end

#selectmonster 756
#gcost 0
#end

#selectmonster 757
#gcost 0
#end

#selectmonster 758
#gcost 0
#end

#selectmonster 759
#gcost 0
#end

#selectmonster 762
#gcost 0
#end

#selectmonster 966
#gcost 0
#end




















-- Soulless

-- Normal default soulless:
-- hp=15 prot=0 mr=5 str=12 att=4 def=3 prec=4 ap=2/6

-- Normal default longdead (eg #194):
-- hp=5 prot=0 mr=9 str=10 att=11 def=9 prec=10 ap=3/9

-- by default...  soulless are UTTERLY WORTHLESS even if they are not banished,
-- despite being harder to get than longdeads!

-- humans get 2 x "Fist" because all other soulless get "Claw"
#selectmonster 197
#name "Soulless"
#mr 6
#att 5
#def 2
#prec 5
#weapon "Fist"
#weapon "Fist"
#armor "Missile Resistance"
#end

-- I want to give them a life-draining bite, but I can't...
#selectmonster 198
#name "Ghoul"
#descr "Ghouls are humans under the curse of Hunger. By eating the flesh of dead humans, their bodies and minds decay and transform. Pale and putrescent, they follow armies to feed on the dead and dying, and occasionally don scraps of ruined armor out of some forgotten survival instinct. The hands of a ghoul are transformed into claws that stiffen the muscles of those they scratch."
#mr 9
#armor "Armor Scraps"
#weapon 43
#weapon 43
#end

#selectmonster 315
#name "Soulless Giant"
#prot 4
#mr 7
#att 5
#def 2
#prec 5
#armor "Missile Resistance"
#end

#selectmonster 317
#name "Soulless of Caelum"
#mr 7
#att 5
#def 2
#prec 5
#armor "Missile Resistance"
#end

#selectmonster 318
#name "Soulless of Atlantis"
#prot 2
#mr 6
#att 5
#def 2
#prec 4
#armor "Missile Resistance"
#end

#selectmonster 319
#name "Soulless of C'tis"
#prot 4
#mr 7
#att 5
#def 2
#prec 5
#armor "Missile Resistance"
#end



-- Soulless Warriors

#selectmonster 914
#name "Soulless Warrior"
#hp 16
#mr 6
#str 13
#att 6
#def 3
#prec 6
#armor "Missile Resistance"
#armor "Ring Mail Cuirass"
#end

#selectmonster 915
#name "Soulless Warrior"
#hp 16
#mr 6
#str 13
#att 6
#def 3
#prec 6
#armor "Missile Resistance"
#armor "Chain Mail Hauberk"
#end

#selectmonster 916
#name "Soulless Jotun Warrior"
#descr "Recently deceased warriors unnaturally animated into a state of false life, the Soulless Warriors are armed with the weapons they held as they died.  Reanimated warriors are typically stronger have better combat aptitude than civilians who have died of sickness or age.  Though lacking vital organs, soulless are in a constant state of decomposition and are easier to destroy than Liches or Wights.  Soulless are often called zombies.  They are mindless and will never rout unless their master is killed, but will quickly dissolve into nothing should they be left without undead leadership."
#hp 48
#prot 4
#mr 7
#str 25
#att 6
#def 3
#prec 6
#armor "Missile Resistance"
#armor "Full Leather Armor"
#end

#selectmonster 917
#name "Soulless Jotun Warrior"
#descr "Recently deceased warriors unnaturally animated into a state of false life, the Soulless Warriors are armed with the weapons they held as they died.  Reanimated warriors are typically stronger have better combat aptitude than civilians who have died of sickness or age.  Though lacking vital organs, soulless are in a constant state of decomposition and are easier to destroy than Liches or Wights.  Soulless are often called zombies.  They are mindless and will never rout unless their master is killed, but will quickly dissolve into nothing should they be left without undead leadership."
#hp 48
#prot 4
#mr 7
#str 25
#att 6
#def 3
#prec 6
#armor "Missile Resistance"
#armor "Chain Mail Hauberk"
#end

#selectmonster 918
#name "Soulless Caelian Warrior"
#descr "Recently deceased warriors unnaturally animated into a state of false life, the Soulless Caelian Warriors are armed with the weapons they held as they died.  Reanimated warriors are typically stronger have better combat aptitude than civilians who have died of sickness or age.  Though lacking vital organs, soulless are in a constant state of decomposition and are easier to destroy than Liches or Wights.  This decomposition has also rendered their wings incapable of flight.  Often called zombies, soulless are mindless and will never rout.  However, they will quickly dissolve into nothing should they be left without undead leadership."
#hp 12
#mr 7
#str 25
#att 6
#def 3
#prec 6
#weapon "Ice Lance"
#armor "Missile Resistance"
#armor "Ice Studded Armor"
#end

#selectmonster 919
#name "Soulless Atlantian Warrior"
#descr "Recently deceased warriors unnaturally animated into a state of false life, the Soulless Warriors are armed with the weapons they held as they died.  Reanimated warriors are typically stronger have better combat aptitude than civilians who have died of sickness or age.  Though lacking vital organs, soulless are in a constant state of decomposition and are easier to destroy than Liches or Wights.  Soulless are often called zombies.  They are mindless and will never rout unless their master is killed, but will quickly dissolve into nothing should they be left without undead leadership."
#hp 18
#prot 2
#mr 6
#str 14
#att 6
#def 3
#prec 5
#armor "Missile Resistance"
#end

#selectmonster 920
#name "Soulless Reef Warrior"
#descr "Recently deceased warriors unnaturally animated into a state of false life, the Soulless Warriors are armed with the weapons they held as they died.  Reanimated warriors are typically stronger have better combat aptitude than civilians who have died of sickness or age.  Though lacking vital organs, soulless are in a constant state of decomposition and are easier to destroy than Liches or Wights.  Soulless are often called zombies.  They are mindless and will never rout unless their master is killed, but will quickly dissolve into nothing should they be left without undead leadership."
#hp 18
#prot 2
#mr 6
#str 14
#att 6
#def 3
#prec 5
#armor "Missile Resistance"
#armor "Coral Cuirass"
#end

#selectmonster 921
#name "Soulless Warrior of C'tis"
#descr "Recently deceased warriors unnaturally animated into a state of false life, the Soulless Warriors are armed with the weapons they held as they died.  Reanimated warriors are typically stronger have better combat aptitude than civilians who have died of sickness or age.  Though lacking vital organs, soulless are in a constant state of decomposition and are easier to destroy than Liches or Wights.  Soulless are often called zombies.  They are mindless and will never rout unless their master is killed, but will quickly dissolve into nothing should they be left without undead leadership."
#hp 17
#mr 7
#str 13
#att 6
#def 3
#prec 6
#armor "Missile Resistance"
#end

#selectmonster 922
#name "Soulless Warrior of C'tis"
#descr "Recently deceased warriors unnaturally animated into a state of false life, the Soulless Warriors are armed with the weapons they held as they died.  Reanimated warriors are typically stronger have better combat aptitude than civilians who have died of sickness or age.  Though lacking vital organs, soulless are in a constant state of decomposition and are easier to destroy than Liches or Wights.  Soulless are often called zombies.  They are mindless and will never rout unless their master is killed, but will quickly dissolve into nothing should they be left without undead leadership."
#hp 17
#mr 7
#str 13
#att 6
#def 3
#prec 6
#armor "Missile Resistance"
#armor "Scale Mail Hauberk"
#end



















-- note:  I could give dryads +1prot also


-- Other affected units

#selectmonster 951
#name "Harab Seraph"
#weapon "Ice Blade"
#armor "Ice Helmet"
#rcost 6
#att 9
#def 9
#end

#selectmonster 770
#name "White Satyr"
#prot 2
#end


-- note:  I could give dryads +1prot also







-- Cavalry Guidelines:
-- Note that the existance of guidelines does not mean they are followed.
   
-- Type	Protection		GCOST		RCOST		ENC	MOVE

-- Light:	0-9			14		+4		4	3
-- Medium:	10-14			22		x1.5+6	4	2
-- Heavy:	15+			30		x2+10		5	2
-- Elite:	17+ & stats+	40		x2+12		5	2

-- Other factors to consider:

-- Factor					GCOST

-- Bow: 					+2
-- Light Lance:				+2
-- Full Lance:				+6
-- Mount Attacks:				varies
-- Trample:					+.25*(size^3)
-- Mount Survives Rider:		+10 (varies)
-- Mount Joins Army:			varies
-- Slower Than a Horse:			-2 to 10
-- Protection Above Minimum:		+0 to 2 each
-- Bonus Stats:				varies


-- Other changes:  all cavs get +1 str to reflect mount's momentum,
-- and +2 hp to reflect hits taken by the mount (+3 on heavy cav)
-- heavy and medium cavs get minimum 11 morale
-- light cav precision penalties reduced, for 4 reasons:
-- 1) higher seat gives better vision and better angle
-- 2) they are trained to shoot / throw from horseback
-- 3) horses will often be still when firing
-- 4) the penalty made them worthless

#selectmonster 3
#name "Serpent Cataphract"
#gcost 55
#rcost 58
#hp 15
#str 13
#att 13
#mor 13
#end

#selectmonster 4
#name "Serpent"
#gcost 0
#end

#selectmonster 5
#name "Serpent Lord"
#gcost 110
#rcost 58
#goodleader
#hp 16
#str 14
#end

#selectmonster 19
#name "Heavy Cavalry"
#gcost 35
#rcost 42
#hp 13
#str 11
#mor 11
#prec 8
#end

-- Indy and Arco
#selectmonster 20
#name "Medium Cavalry"
#descr "Medium Cavalry trade the mobility and ranged weapons of light cavalry for heavier armor, lances, and horses bred for war rather than speed. The use of a horse reduces the encumbrance of armor and provides the rider with great speed and flexibility. It also allows for an initial lance charge capable of breaking most enemy units. War horses are expensive and love to eat."
#gcost 25
#rcost 24
#hp 12
#str 11
#mor 11
#prec 8
#enc 4
#end

#selectmonster 21
#name "Heavy Cavalry"
#gcost 40
#rcost 48
#hp 13
#str 11
#mor 11
#prec 8
#enc 5
#end

#selectmonster 22
#name "Knight"
#gcost 45
#rcost 48
#hp 14
#str 12
#prec 8
#end

-- Command should come naturally to nobility
#selectmonster 23
#name "Knight Commander"
#gcost 75
#rcost 50
#goodleader
#hp 15
#str 13
#prec 8
#end

#selectmonster 24
#name "Light Cavalry"
#gcost 14
#rcost 8
#hp 12
#str 11
#mor 10
#prec 10
#enc 4
#end

#selectmonster 25
#name "Light Cavalry"
#gcost 16
#rcost 9
#hp 12
#str 11
#mor 10
#prec 10
#enc 4
#end

#selectmonster 26
#name "Light Cavalry"
#gcost 16
#rcost 11
#hp 12
#str 11
#mor 10
#prec 10
#enc 4
#end

-- 30g is way too high, considering they're scarcely better
-- than 12g Man longbows.
#selectmonster 27
#name "Centaur"
#gcost 24
#rcost 3
#prec 13
#end

#selectmonster 44
#name "Mounted Commander"
#gcost 55
#rcost 34
#hp 13
#str 11
#mor 12
#att 11
#def 11
#prec 10
#enc 5
#end

#selectmonster 45
#name "Mounted Commander"
#gcost 50
#rcost 24
#hp 13
#str 11
#mor 12
#prec 10
#enc 4
#mapmove 3
#ap 23
#end

#selectmonster 46
#name "Mounted Commander"
#gcost 45
#rcost 10
#hp 12
#str 11
#mor 11
#prec 10
#enc 4
#end

-- Man
#selectmonster 57
#name "Knight"
#gcost 50
#rcost 51
#hp 15
#str 13
#mor 14
#prec 8
#enc 5
#end

-- Man
#selectmonster 58
#name "Knight of the Stone"
#gcost 0
#hp 19
#str 14
#mor 16
#prec 9
#enc 5
#end

-- Standard 4 based on description "radiates confidence"
-- Animalawe because unicorns are sacrosanct
-- Man
#selectmonster 64
#name "Knight of Avalon"
#descr "The Knights of Avalon ride the legendary unicorns of Avalon, mounts of unsurpassed speed trained by the Witch Mothers. Clad in brightest silver and enchanted by the Witches, the Knights of Avalon radiate confidence and resolve. The mystical power of their mounts protects them from long-lasting battle wounds, and few animals would dare attack a unicorn."
#gcost 75
#rcost 61
#hp 17
#str 13
#att 13
#mor 15
#prec 8
#enc 5
#standard 4
#animalawe 2
#armor "Silver Helmet"
#armor "Silver Chain Mail"
#armor "Kite Shield"
#end

-- Ulm
#selectmonster 69
#name "Black Knight"
#gcost 60
#rcost 70
#hp 18
#str 14
#mor 15
#def 12
#prec 8
#enc 5
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#armor "Kite Shield"
#end

-- Ulm
#selectmonster 70
#name "Black Lord"
#gcost 110
#rcost 70
#hp 20
#str 15
#def 13
#mor 16
#prec 9
#enc 5
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#armor "Kite Shield"
#end

-- Marignon
-- low protection, no lance compared to other elites
#selectmonster 134
#name "Royal Guard"
#gcost 46
#rcost 48
#hp 15
#str 12
#mor 14
#prec 8
#enc 5
#armor "Gilded Full Helmet"
#armor "Gilded Chain Mail"
#armor "Kite Shield"
#end

-- Marignon
#selectmonster 135
#name "Knight of the Chalice"
#gcost 90
#rcost 51
#hp 17
#str 13
#def 12
#mor 15
#prec 8
#enc 5
#armor "Gilded Full Helmet"
#armor "Gilded Chain Mail"
#armor "Kite Shield"
#end

-- Indy
#selectmonster 136
#name "Tribal Chief"
#gcost 50
#rcost 9
#hp 13
#str 12
#mor 12
#prec 10
#enc 4
#end

-- Indy
#selectmonster 137
#name "Tribal Cavalry"
#gcost 17
#rcost 8
#hp 12
#str 11
#mor 11
#prec 10
#enc 4
#end

-- Arco
-- higher MR because elephants are intelligent
-- higher DEF because it is very hard to attack a rampaging elephant
-- fear -5 because rampaging elephants are some of the scariest
-- things on earth.  They destroy entire towns.
-- I really want elephants to have berserk but that would make them too powerful,
-- since berserkers only attack the enemy in Doms II.
#selectmonster 150
#name "Elephant"
#gcost 120
#rcost 20
#mr 8
#def 11
#prec 4
#fear -5
#end

-- Ermor
-- Description says they are terrifying...
-- Since they cannot gain experience, I buffed their stats
-- to bring them in line with other knights.
#selectmonster 184
#name "Knight of the Unholy Sepulchre"
#hp 9
#str 12
#att 14
#def 12
#mr 14
#prec 8
#fear -4
#end

#selectmonster 188
#name "Mound King"
#hp 9
#str 13
#prec 9
#end

#selectmonster 189
#name "Longdead Horseman"
#hp 6
#str 11
#prec 8
#end

-- 2 people + horse + cart, implies HP well over 10
-- MR 11 because a single-person spell
-- should be less likely to compromise the unit
#selectmonster 200
#name "Chariot"
#gcost 35
#rcost 24
#hp 16
#str 11
#mr 11
#end

#selectmonster 210
#name "Lobster"
#gcost 0
#weapon 235
#end

#selectmonster 642
#name "Lobster"
#gcost 0
#weapon 235
#end

#selectmonster 211
#name "War Lobster"
#gcost 50
#rcost 10
#hp 16
#armor "Sharkskin Cuirass"
#armor "Turtle Shell Shield"
#end

#selectmonster 231
#name "Centaur Hierophant"
#gcost 80
#rcost 3
#weapon "Dagger"
#weapon 55
#weapon "Long Bow"
#end

#selectmonster 232
#name "Centaur Commander"
#gcost 60
#rcost 44
#armor "Bronze Helmet"
#armor "Bronze Centaur Barding"
#armor "Round Shield"
#end

#selectmonster 233
#name "Centaur Cataphract"
#gcost 35
#rcost 44
#armor "Bronze Helmet"
#armor "Bronze Centaur Barding"
#armor "Round Shield"
#end

-- why should minotaur att / def be the same as human militia?
-- After all, they are geared toward combat,
-- and listed as much faster than humans
-- size 3 trample is not that great, anyway.
#selectmonster 234
#name "Minotaur"
#gcost 30
#rcost 7
#att 10
#def 9
#end

#selectmonster 235
#name "War Minotaur"
#gcost 35
#rcost 46
#hp 26
#att 11
#def 10
#armor "Bronze Helmet"
#armor "Bronze Cuirass"
#end

#selectmonster 236
#name "Minotaur Lord"
#gcost 75
#rcost 63
#hp 28
#att 12
#def 11
#armor "Bronze Helmet"
#armor "Bronze Hauberk"
#end

-- Vanheim
#selectmonster 262
#name "Van"
#gcost 70
#rcost 16
#hp 16
#str 12
#coldres 25
#end

-- Jotun
#selectmonster 282
#name "Wolf Rider"
#gcost 18
#rcost 7
#hp 10
#str 10
#att 11
#def 11
#prec 9
#coldres 25
#end

-- Jotun
#selectmonster 283
#name "Chief"
#gcost 50
#rcost 8
#hp 12
#str 10
#att 11
#def 11
#prec 9
#coldres 25
#end

-- Merc
#selectmonster 292
#name "Heavy Cavalry"
#hp 13
#str 11
#prec 8
#end

-- Merc
#selectmonster 293
#name "Captain"
#mounted
#hp 14
#str 11
#prec 8
#end

#selectmonster 365
#name "Centaur Chariot"
#gcost 40
#rcost 24
#hp 16
#str 11
#mr 11
#prot 5
#end

-- Amazon
-- Drastic price cut.  Who used these?
-- Composite bow added, to emulate extra range,
-- damage, and precision when firing while airborne.
#selectmonster 367
#name "Pegasus Rider"
#gcost 35
#rcost 8
#hp 12
#str 10
#mor 12
#armor "Ring Mail Cuirass"
#armor "Helmet"
#armor "Buckler"
#weapon "Spear"
#weapon 56
#weapon "Composite Bow"
#end

-- Amazon
#selectmonster 368
#name "Gryphon"
#gcost 0
#end

-- Amazon
-- Gains fireres 40 as a compromise
-- since rider has full and gryphon has none.
#selectmonster 612
#name "Gryphon Rider"
#gcost 115
#rcost 20
#hp 13
#str 11
#mr 11
#prec 9
#fireres 40
#end

-- Amazon
-- These gain no HP since the amazons are using their
-- own life force to hold the horse together
#selectmonster 369
#name "Nightmare"
#gcost 60
#rcost 14
#str 10
#prec 9
#end

-- Amazon
#selectmonster 370
#name "Jade Maiden"
#gcost 40
#rcost 12
#hp 12
#str 10
#mr 11
#mor 12
#prec 10
#end

-- Man
#selectmonster 376
#name "Green Knight"
#hp 19
#str 14
#mr 15
#animalawe 2
#armor "Full Helmet"
#armor "Shimmering Green Mail"
#armor "Kite Shield"
#reinvigoration 1
#regeneration 15
#end

-- Ulm
#selectmonster 377
#name "Hero"
#hp 23
#str 16
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#armor "Kite Shield"
#end

-- Ulm
#selectmonster 378
#name "Hero"
#hp 20
#str 16
#animalawe 2
#forestsurvival
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#armor "Kite Shield"
#end

-- Would she really ride around playing knight with no armor?
-- Man
#selectmonster 381
#name "Heroine"
#hp 16
#str 13
#mr 11
#mor 12
#prec 10
#animalawe 2
#armor "Ring Mail Cuirass"
#armor "Round Shield"
#end

-- Indy (site)
#selectmonster 390
#name "Grey Knight"
#gcost 150
#rcost 60
#hp 15
#str 12
#prec 8
#end

-- Indy (site)
#selectmonster 391
#name "Grey Lord"
#gcost 220
#rcost 60
#hp 17
#str 13
#end

-- Caelum
#selectmonster 419
#name "Mammoth"
#gcost 140
#rcost 22
#fear -5
#def 9
#mr 8
#fireres -50
#end

-- Ryleh
#selectmonster 425
#name "Shambler Thrall"
#gcost 35
#rcost 1
#end

-- Marignon
-- Gets MR 14 to match a priest.
-- Holy sword will get bonus vs Undead when possible
#selectmonster 440
#name "Paladin"
#gcost 140
#rcost 51
#hp 18
#str 14
#mr 14
#weapon "Holy Sword"
#weapon "Lance"
#weapon 55
#armor "Gilded Full Helmet"
#armor "Gilded Chain Mail"
#armor "Kite Shield"
#end

-- Indy
#selectmonster 447
#name "Troglodyte"
#gcost 50
#rcost 1
#end

-- Indy
#selectmonster 450
#name "Horse Brother"
#gcost 16
#rcost 7
#hp 12
#str 11
#prec 10
#end

-- Indy
#selectmonster 451
#name "Horse Brother"
#gcost 45
#rcost 8
#hp 14
#str 12
#prec 10
#end

-- Vanheim
#selectmonster 463
#name "Fay Boar"
#gcost 100
#rcost 4
#str 13
#prot 5
#att 10
#def 11
#holy
#neednoteat
#coldres 25
#weapon "Bite"
#weapon "Gore"
#end

-- Pythium
#selectmonster 506
#name "Hero"
#hp 19
#str 15
#end

-- Ulm
#selectmonster 507
#name "Heroine"
#hp 17
#str 13
#ap 34
#armor "Ringmail Hauberk of Ulm"
#armor "Helmet"
#armor "Round Shield"
#animalawe 2
#forestsurvival
#end

-- Jotun
#selectmonster 508
#name "Wolf Lord"
#coldres 25
#mor 14
#hp 14
#str 12
#end

-- Indy
#selectmonster 545
#name "Shark Knight"
#gcost 45
#rcost 18
#hp 18
#str 13
#prec 8
#end

-- Merc / Transformation
#selectmonster 549
#name "Boar"
#str 11
#gcost 0
#end

-- Van
#selectmonster 590
#name "Hero"
#hp 16
#str 13
#coldres 25
#end

-- IA Pan
#selectmonster 698
#name "Centaur Cataphract"
#gcost 35
#rcost 36
#end

-- IA Pan
#selectmonster 699
#name "Cataphract Commander"
#gcost 60
#rcost 36
#end

-- IA Pan
#selectmonster 700
#name "Minotaur Soldier"
#gcost 35
#rcost 41
#att 11
#def 10 
#end

-- IA Pan
#selectmonster 701
#name "Minotaur Commander"
#gcost 60
#rcost 57
#att 12
#def 11 
#end

-- IA Pan
#selectmonster 702
#name "Grove Guard"
#gcost 50
#rcost 57
#att 11
#def 11
#end

-- IA Pan
#selectmonster 703
#name "Keeper of Traditions"
#gcost 90
#rcost 57
#att 12
#def 11 
#end

-- Pan
#selectmonster 707
#name "Centaur Warrior"
#gcost 35
#rcost 11
#att 11
#end

-- IF Ulm
#selectmonster 738
#name "Black Templar"
#gcost 90
#rcost 70
#att 13
#hp 18
#str 14
#prec 8
#mr 11
#armor "Full Helmet of Ulm"
#armor "Full Plate of Ulm"
#armor "Kite Shield"
#end

-- SC Pythium
#selectmonster 763
#name "Serpent Cataphract"
#gcost 60
#rcost 58
#hp 15
#str 13
#mr 11
#end

-- SC Pythium
#selectmonster 764
#name "Serpent"
#gcost 0
#mr 8
#end

-- SC Pythium
#selectmonster 765
#name "Serpent Lord"
#gcost 130
#rcost 58
#hp 18
#str 14
#end

-- Pan
-- Looks like he's wearing a helmet. Compare to Centaur Hierophant.
-- I want to give him a helmet, but it always messes up "Centaur Barding"
-- number 103, so I had to make a new barding and refer to it by name.
#selectmonster 769
#name "White Centaur"
#gcost 60
#rcost 15
#att 12
#def 15
#mor 13
#weapon "Light Lance"
#weapon 55
#weapon "Javelin"
#armor "Bronze Helmet"
#armor "Light Centaur Barding"
#armor "Round Shield"
#end

-- CW Pan
-- A sacred warrior that wreaks divine wrath needs berserk 4 :)
#selectmonster 787
#name "Black Centaur"
#gcost 60
#rcost 15
#att 12
#def 15
#mor 13
#berserk 4
#weapon "Light Lance"
#weapon 55
#weapon "Javelin"
#armor "Bronze Helmet"
#armor "Light Centaur Barding"
#armor "Round Shield"
#end

-- Tien Chi SA + std
#selectmonster 788
#name "Horseman"
#gcost 15
#rcost 12
#hp 12
#str 11
#prec 10
#end

-- Tien Chi std
#selectmonster 789
#name "Heavy Horseman"
#gcost 22
#rcost 28
#hp 12
#str 11
#prec 10
#end

-- Tien Chi std
#selectmonster 790
#name "Imperial Horseman"
#gcost 30
#rcost 30
#hp 14
#str 11
#weapon "Imperial Dao"
#weapon "Lance"
#weapon 56
#weapon "Composite Bow"
#end

-- Tien Chi std
#selectmonster 791
#name "Red Guard"
#gcost 70
#rcost 36
#hp 16
#str 12
#weapon "Imperial Dao"
#weapon "Lance"
#weapon 56
#weapon "Composite Bow"
#armor "Imperial Scale Mail"
#armor "Helmet"
#armor "Round Shield"
#end

-- Tien Chi
#selectmonster 792
#name "General"
#hp 14
#str 11
#prec 10
#gcost 65
#rcost 30
#end

-- Tien Chi std
-- They get holy magic so they can bless redguard
-- No TC priests get more than 1 strat move
#selectmonster 793
#name "Prince General"
#gcost 150
#rcost 36
#hp 17
#str 12
#armor "Imperial Scale Mail"
#armor "Helmet"
#armor "Round Shield"
#weapon "Imperial Dao"
#weapon "Lance"
#weapon 56
#weapon "Composite Bow"
#magicskill 8 2
#end

-- SC Pythium
#selectmonster 866
#name "Hero"
#hp 19
#str 15
#end

-- Machaka
#selectmonster 884
#name "Great Spider"
#gcost 10
#end

-- Machaka
#selectmonster 885
#name "Spider Rider"
#gcost 40
#rcost 5
#hp 13
#str 11
#att 11
#def 11
#end

-- Machaka
#selectmonster 886
#name "Spider Knight"
#gcost 55
#rcost 26
#hp 15
#str 11
#att 11
#def 11
#prec 8
#end

-- Machaka
#selectmonster 887
#name "Spider Lord"
#gcost 90
#rcost 26
#hp 16
#str 12
#end

-- Machaka
#selectmonster 888
#name "Hunter Spider"
#gcost 30
#mr 8
#end

-- Machaka
#selectmonster 889
#name "Black Hunter"
#gcost 125
#rcost 38
#hp 16
#str 12
#end

-- Machaka
#selectmonster 890
#name "Hunter Lord"
#gcost 170
#rcost 38
#goodleader
#hp 17
#str 12
#end

-- SA Tien Chi
#selectmonster 927
#name "Noble"
#gcost 80
#rcost 35
#hp 15
#str 12
#end

-- BK Tien Chi
#selectmonster 930
#name "Khan"
#gcost 85
#rcost 28
#hp 17
#str 13
#prec 10
#weapon "Falchion"
#weapon "Lance"
#weapon 56
#weapon "Composite Bow"
#end

-- BK Tien Chi
#selectmonster 938
#name "Barbarian Horseman"
#gcost 14
#rcost 12
#hp 13
#str 11
#prec 10
#end

-- BK Tien Chi
#selectmonster 939
#name "Barbarian Horseman"
#gcost 20
#rcost 28
#hp 14
#str 11
#prec 10
#end

-- Indy?
#selectmonster 1058
#name "Hippocampus"
#end

#selectmonster 1059
#name "Knight of the Deeps"
#gcost 85
#rcost 61
#end

#selectmonster 1060
#name "Triton Knight"
#end

#selectmonster 1061
#name "Triton Prince"
#gcost 125
#rcost 61
#end

#selectmonster 1062
#name "Sea Stag"
#end

#selectmonster 1063
#name "Sea Lion"
#end

#selectmonster 1074
#name "Wind Rider"
#gcost 110
#rcost 38
#hp 15
#str 12
#att 13
#armor "Bronze Full Helmet"
#armor "Bronze Hauberk"
#armor "Round Shield"
#end

#selectmonster 1075
#name "Wind Lord"
#gcost 150
#rcost 38
#hp 16
#str 13
#armor "Bronze Full Helmet"
#armor "Bronze Hauberk"
#armor "Round Shield"
#end

#selectmonster 1078
#name "Chariot"
#gcost 30
#rcost 41
#hp 12
#str 11
#weapon "Bronze Short Sword"
#armor "Bronze Helmet"
#armor "Bronze Cuirass"
#end

#selectmonster 1079
#name "Chariot Archer"
#gcost 35
#rcost 31
#hp 12
#str 11
#mr 11
#weapon "Bronze Short Sword"
#weapon "Short Bow"
#armor "Bronze Helmet"
#armor "Bronze Ringmail Cuirass"
#end

-- half the riders, half the cost... :)
#selectmonster 1080
#name "Archerless Chariot"
#gcost 20
#hp 12
#str 11
#weapon "Bronze Short Sword"
#armor "Bronze Helmet"
#armor "Bronze Ringmail Cuirass"
#end

#selectmonster 1081
#name "Chariot Commander"
#gcost 70
#rcost 41
#hp 12
#str 11
#weapon "Bronze Short Sword"
#armor "Bronze Helmet"
#armor "Bronze Cuirass"
#end

#selectmonster 1084
#name "Moose"
#gcost 0
#coldres 25
#end

-- I gave it protection between 4 (moose) and 9 (vaetti)
#selectmonster 1085
#name "Moose Riders"
#gcost 38
#rcost 12
#coldres 25
#prot 7
#end

#selectmonster 1086
#name "Troll Moose Knight"
#gcost 110
#rcost 37
#end
































-- Mages


#selectmonster 85
#name "Anathemant Salamander"
#gcost 175
#prec 9
#coldres -25
#end

#selectmonster 86
#name "Anathemant Dragon"
#gcost 325
#prec 10
#coldres -25
#end

#selectmonster 87
#name "Demonbred"
#gcost 260
#prec 9
#coldres -25
#end

#selectmonster 89
#name "Warlock"
#prec 9
#coldres -25
#end

-- Warlock apprentices were not really very efficient for blood hunting,
-- despite the description, even though Abysia is one of three blood nations.
#selectmonster 923
#name "Warlock Apprentice"
#descr "In the Souldercone, young and promising Abysians are trained in blood magic. The Apprentices are much feared, as they often carry out the task of collecting young virgins for their masters' sacrifices. Long experience has let them sense the innate purity of potential blood slaves, allowing them to hunt as though they had an extra level of blood magic. Warlock Apprentices are Abysians and radiate the hellish heat characteristic of their race."
#douse 1
#fear -5
#prec 9
#coldres -25
#end

-- Undead leadership fixes bug noted in Edi's unit database
#selectmonster 121
#name "Demonbred"
#prec 9
#okundeadleader
#coldres -25
#end

#selectmonster 731
#name "Mictlan Priest"
#gcost 80
#rcost 1
#weapon "Obsidian Dagger"
#end

#selectmonster 733
#name "Rain Priest"
#gcost 230
#rcost 1
#weapon "Obsidian Dagger"
#end

#selectmonster 734
#name "Moon Priest"
#gcost 230
#rcost 1
#weapon "Obsidian Dagger"
#end

#selectmonster 735
#name "High Priest of the Sun"
#gcost 370
#rcost 1
#weapon "Obsidian Dagger"
#end

-- All jotunheim native races should have SOME cold resistance
#selectmonster 913
#name "Vaetti Hag"
#gcost 55
#rcost 6
#coldres 25
#end

-- Tien Chi Hero
#selectmonster 942
#name "Immortal"
#weapon "Pruning Knife"
#armor "Immortal's Robe"
#end

-- Tien Chi Hero
#selectmonster 943
#name "Immortal"
#descr "Lu Tung-Pin is one of the Immortals, the ancient heroes of T'ien Ch'i that have attained a limited form of divinity. Lu Tung-Pin became an Immortal when he was given a sip of wine by a mysterious old man. He fell asleep and had many a strange dream. When he awoke, he secluded himself and lived as a hermit until he had mastered, perfected, and eventually transcended the arts of swordsmanship and inner alchemy. He is armed with an enchanted demon slaying sword given to him by a Dragon. He also wields an annoying Fly Whisk. Lu Tung-Pin wears no armor but a robe, but his divine swordsmanship allows him to swat arrows from the sky like flies before his whisk, and stroll through a raging battlefield unscathed while pondering the meaning of good and evil."
#mor 16
#str 12
#att 16
#def 14
#ap 14
#ambidextrous 4
#armor "Sword Deflection"
#armor "Immortal's Robe"
#end

-- Tien Chi Hero
#selectmonster 944
#name "Master with the Iron Crutch"
#att 12
#armor "Flea-Infested Cape"
#end

#selectmonster 951
#name "Harab Seraph"
#weapon "Ice Blade"
#armor "Ice Helmet"
#rcost 6
#att 9
#def 9
#end

#selectmonster 991
#name "Newt"
#prec 9
#end

#selectmonster 1011
#name "Fortune Teller"
#end

#selectmonster 1091
#name "Sanguine Acolyte"
#prec 9
#end

#selectmonster 1092
#name "Sanguine Anathemant"
#prec 9
#end

-- Attack should be better than a Jotun Jarl, IMO
#selectmonster 844
#name "Niefel Jarl"
#gcost 500
#rcost 60
#str 25
#att 13
#weapon "Niefel Longsword"
#armor "Ice Helmet"
#armor "Mammoth Leather Armor"
#armor "Ice Aegis"
#end

#selectmonster 325
#name "Master Smith"
#gcost 140
#rcost 10
#enc 4
#hp 12
#armor "Ringmail Hauberk of Ulm"
#end

#selectmonster 850
#name "Sidhe Champion"
#gcost 140
#rcost 19
#armor "Bronze Chain Cuirass"
#armor "Bronze Helmet"
#armor "Round Shield"
#weapon "Ancient Bronze Sword"
#weapon "Javelin"
#end

#selectmonster 502
#name "Empoisoner"
#gcost 110
#end



-- Vanheim
#selectmonster 263
#name "Vanherse"
#gcost 160
#rcost 16
#hp 17
#str 13
#coldres 25
#end

-- Vanheim
#selectmonster 264
#name "Vanjarl"
#gcost 280
#rcost 17
#hp 18
#str 14
#coldres 25
#end


-- Indy (site)
#selectmonster 389
#name "Fire Lord"
#gcost 150
#rcost 51
#hp 17
#str 13
#fireres 25
#armor "Gilded Full Helmet"
#armor "Gilded Chain Mail"
#armor "Kite Shield"
#end


-- Tuatha
-- These guys do a little bit of foraging :)
#selectmonster 851
#name "Cu Sidhe"
#gcost 15
#rcost 1
#def 12
#hp 20
#coldres 25
#weapon "Shred"
#supplybonus 1
#end


-- Marignon hero
#selectmonster 589
#name "Witch Hunter General"
#hp 11
#str 9
#end

-- Helheim
#selectmonster 847
#name "Hangadrott"
#gcost 400
#rcost 17
#hp 18
#str 14
#coldres 25
#end

-- Tuatha
#selectmonster 848
#name "Sidhe Lord"
#gcost 280
#rcost 18
#hp 18
#str 14
#armor "Bronze Chain Cuirass"
#armor "Bronze Helmet"
#armor "Round Shield"
#end


-- Tuatha
#selectmonster 856
#name "Tuatha"
#gcost 390
#rcost 16
#hp 18
#str 14
#animalawe 2 
#armor "Light Weight Scale Mail"
#armor "Bronze Helmet"
#armor "Round Shield"
#end

-- Indy
#selectmonster 875
#name "Warrior Mage"
#gcost 150
#rcost 60
#hp 17
#str 13
#end

-- Machaka sorceress alt
#selectmonster 898
#name "Great Spider"
#end

-- Machaka sorcerer alt
#selectmonster 899
#name "Hunter Spider"
#end

-- Machaka - Lady of Spiders alt
#selectmonster 947
#name "Great Spider"
#end

-- Van
#selectmonster 948
#name "Vanadrott"
#gcost 380
#rcost 16
#hp 18
#str 14
#coldres 25
#end

-- Van
#selectmonster 946
#name "Galderman"
#gcost 160
#rcost 1
#hp 14
#str 12
#att 11
#def 11
#ap 12
#coldres 25
#end

#selectmonster 1023
#name "Shrouded One"
#clearmagic
#descr "The Shrouded One is a member of the secretive order of Illuminated Ones. The shroud is only metaphoric, indicitive of their low standing in the Order and the shadowy nature of their work. Used by the Order to gain power over the courts of distant kingdoms, Shrouded Ones are typically sent to gather blood slaves, incite revolts, and assassinate foreign leaders."
#gcost 110
#rcost 1
#hp 12
#mor 12
#str 11
#att 11
#def 11
#ap 12
#enc 2
#stealthy 15
#assassin
#magicskill 7 1
#weapon "Dagger"
#weapon "Poison Dagger"
#armor "Leather Cuirass"
#armor "Armguards"
#end

#selectmonster 1012
#name "Member of the Second Tier"
#clearmagic
#gcost 220
#rcost 1
#hp 11
#mor 12
#str 10
#att 10
#def 10
#ap 11
#enc 4
#stealthy 0
#magicskill 7 2
#magicskill 5 2
#magicskill 52 1
#weapon "Dagger"
#end

#selectmonster 1011
#name "Fortune Teller"
#clearmagic
#gcost 90
#rcost 1
#mor 10
#str 9
#att 9
#def 11
#prec 10
#ap 12
#enc 2
#magicskill 4 1
#magicskill 50 1
#end


-- Nation: Pangaea CW
-- Paths: D2, N3
-- Original Price: 320g
-- Prec: 9
-- Enc: 3
-- Abilities: f(-3), rec, st(+0), surv(f)
#selectmonster 709
#name "Panic Apostate"
#gcost 290
#end


-- Nation: Pangaea CW
-- Paths: N, H2
-- Original Price: 90g (Sacred)
-- Prec: 10
-- Enc: 3
-- Abilities: rec, st(+0), surv(f)
#selectmonster 901
#name "Black Dryad"
#gcost 80
#end


-- Nation: Pangaea NE
-- Paths: E2, N3
-- Original Price: 350g
-- Prec: 9
-- Enc: 3
-- Abilities: rec, st(+0), surv(f)
#selectmonster 706
#name "Pan"
#gcost 320
#end


-- Nation: Pangaea std
-- Paths: E2, N3, ?
-- Original Price: 350g
-- Prec: 9
-- Enc: 3
-- Abilities: rec, st(+0), surv(f)
#selectmonster 238
#name "Pan"
#gcost 320
#end


-- Nation: Pangaea std
-- Paths: N3, B2
-- Original Price: 320g
-- Prec: 9
-- Enc: 3
-- Abilities: rec, st(+0), surv(f)
#selectmonster 516
#name "Pandemoniac"
#gcost 290
#end


-- Nation: Pythium SC
-- Paths: W, N2, H3, ?
-- Original Price: 190g (Sacred)
-- Prec: 10
-- Enc: 5
-- Abilities: rP(100)
#selectmonster 761
#name "Serpent Priest"
#gcost 200
#end

-- Nation: Pythium std
-- Paths: A2, W, S3, H4, ?
-- Original Price: 380g (Sacred)
-- Prec: 14
-- Enc: 8
-- Abilities: none
#selectmonster 41
#name "Arch Theurg"
#gcost 410
#end

-- Nation: Pythium std
-- Paths: A, W, S2, H3
-- Original Price: 150g (Sacred)
-- Prec: 11
-- Enc: 6
-- Abilities: none
#selectmonster 42
#name "Theurg"
#gcost 180
#end

-- Nation: T'ien Chi S&A
-- Paths: FAWS, H3, #$
-- Original Price: 250g (Sacred)
-- Prec: 11
-- Enc: 5
-- Abilities: fly
#selectmonster 941
#clearmagic
#name "Celestial Master"
#gcost 265
#magicskill 0 1
#magicskill 1 1
#magicskill 2 2
#magicskill 4 1
#magicskill 51 1
#magicskill 52 2
#magicskill 8 3
#end


-- Nation: T'ien Chi std & BK
-- Paths: F, A, W2, S, H3, ?
-- Original Price: 250g (Sacred)
-- Prec: 11
-- Enc: 5
-- Abilities: none
#selectmonster 803
#name "Celestial Master"
#gcost 265
#magicskill 51 1
#magicskill 1 2
#magicskill 2 1
#magicskill 8 3
#end


-- Nation: T'ien Chi S&A
-- Paths: FAEWN#, H2
-- Original Price: 190g (Sacred)
-- Prec: 11
-- Enc: 5
-- Abilities: none
#selectmonster 940
#clearmagic
#name "Master of the Five Elements"
#gcost 250
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 6 1
#magicskill 51 2
#magicskill 8 2
#end




#end

